/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.remoteserver.javalib;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.robotframework.javalib.beans.annotation.IKeywordExtractor;
import org.robotframework.javalib.factory.KeywordFactory;
import org.robotframework.javalib.keyword.Keyword;
import org.robotframework.javalib.util.IKeywordNameNormalizer;
import org.robotframework.javalib.util.KeywordNameNormalizer;
import org.robotframework.remoteserver.javalib.SimpleKeywordExtractor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleKeywordFactory
implements KeywordFactory<Keyword> {
    private Map<String, Keyword> keywords = new HashMap<String, Keyword>();
    private IKeywordNameNormalizer keywordNameNormalizer = new KeywordNameNormalizer();
    private List<String> keywordNames = new ArrayList<String>();

    public SimpleKeywordFactory(Object keywordBean) {
        this.extractKeywordsFromKeywordBean(keywordBean);
    }

    public Keyword createKeyword(String keywordName) {
        String normalizedKeywordName = this.keywordNameNormalizer.normalize(keywordName);
        return this.keywords.get(normalizedKeywordName);
    }

    public String[] getKeywordNames() {
        return this.keywordNames.toArray(new String[0]);
    }

    protected void extractKeywordsFromKeywordBean(Object keywordBean) {
        IKeywordExtractor<Keyword> keywordExtractor = this.createKeywordExtractor();
        Map extractedKeywords = keywordExtractor.extractKeywords(keywordBean);
        this.addKeywordNames(extractedKeywords);
        this.addKeywords(extractedKeywords);
    }

    IKeywordExtractor<Keyword> createKeywordExtractor() {
        return new SimpleKeywordExtractor();
    }

    private void addKeywords(Map<String, Keyword> extractedKeywords) {
        for (String keywordName : extractedKeywords.keySet()) {
            this.handleDuplicateKeywordNames(keywordName);
            this.keywords.put(this.keywordNameNormalizer.normalize(keywordName), extractedKeywords.get(keywordName));
        }
    }

    private void handleDuplicateKeywordNames(String keywordName) {
        if (this.keywords.containsKey(this.keywordNameNormalizer.normalize(keywordName))) {
            throw new RuntimeException("Two keywords with name '" + keywordName + "' found!");
        }
    }

    private void addKeywordNames(Map<String, Keyword> extractedKeywords) {
        this.keywordNames.addAll(extractedKeywords.keySet());
    }
}

