/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.remoteserver.library;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import org.robotframework.remoteserver.library.DynamicApiRemoteLibrary;
import org.robotframework.remoteserver.library.RemoteLibrary;
import org.robotframework.remoteserver.library.RemoteLibraryFactory;
import org.robotframework.remoteserver.library.StaticApiRemoteLibrary;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultRemoteLibraryFactory
implements RemoteLibraryFactory {
    @Override
    public RemoteLibrary createRemoteLibrary(Object library) {
        Class<?> clazz = library.getClass();
        if (DefaultRemoteLibraryFactory.isDynamic(clazz)) {
            Method getKeywordNames = DefaultRemoteLibraryFactory.getMethod(clazz, MethodType.GET_KEYWORD_NAMES);
            Method runKeyword = DefaultRemoteLibraryFactory.getMethod(clazz, MethodType.RUN_KEYWORD);
            Method getKeywordArguments = DefaultRemoteLibraryFactory.getMethod(clazz, MethodType.GET_KEYWORD_ARGUMENTS);
            Method getKeywordDocumentation = DefaultRemoteLibraryFactory.getMethod(clazz, MethodType.GET_KEYWORD_DOCUMENTATION);
            return new DynamicApiRemoteLibrary(library, getKeywordNames, runKeyword, getKeywordArguments, getKeywordDocumentation);
        }
        return new StaticApiRemoteLibrary(library);
    }

    protected static boolean isDynamic(Class<?> clazz) {
        return DefaultRemoteLibraryFactory.getMethod(clazz, MethodType.GET_KEYWORD_NAMES) != null && DefaultRemoteLibraryFactory.getMethod(clazz, MethodType.RUN_KEYWORD) != null;
    }

    protected static Method getMethod(Class<?> clazz, MethodType type) {
        for (Method m : clazz.getMethods()) {
            if (!Modifier.isPublic(m.getModifiers())) continue;
            String name = m.getName();
            Object[] pTypes = m.getParameterTypes();
            if (type.equals((Object)MethodType.GET_KEYWORD_ARGUMENTS) && (name.equals("getKeywordArguments") || name.equals("get_keyword_arguments")) && m.getReturnType() == String[].class && Arrays.equals(pTypes, new Class[]{String.class})) {
                return m;
            }
            if (type.equals((Object)MethodType.GET_KEYWORD_DOCUMENTATION) && (name.equals("getKeywordDocumentation") || name.equals("get_keyword_documentation")) && m.getReturnType() == String.class && Arrays.equals(pTypes, new Class[]{String.class})) {
                return m;
            }
            if (type.equals((Object)MethodType.GET_KEYWORD_NAMES) && (name.equals("getKeywordNames") || name.equals("get_keyword_names")) && m.getReturnType() == String[].class && pTypes.length == 0) {
                return m;
            }
            if (!type.equals((Object)MethodType.RUN_KEYWORD) || !name.equals("runKeyword") && !name.equals("run_keyword") || !m.getReturnType().equals(Object.class) || !Arrays.equals(pTypes, new Class[]{String.class, Object[].class})) continue;
            return m;
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum MethodType {
        GET_KEYWORD_ARGUMENTS,
        GET_KEYWORD_DOCUMENTATION,
        GET_KEYWORD_NAMES,
        RUN_KEYWORD;

    }
}

