/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.remoteserver.library;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.robotframework.remoteserver.library.RemoteLibrary;

public class DynamicApiRemoteLibrary
implements RemoteLibrary {
    private Object library;
    private Method getKeywordNames;
    private Method runKeyword;
    private Method getKeywordArguments;
    private Method getKeywordDocumentation;

    protected DynamicApiRemoteLibrary(Object library, Method getKeywordNames, Method runKeyword, Method getKeywordArguments, Method getKeywordDocumentation) {
        this.library = library;
        this.getKeywordNames = getKeywordNames;
        this.runKeyword = runKeyword;
        this.getKeywordArguments = getKeywordArguments;
        this.getKeywordDocumentation = getKeywordDocumentation;
    }

    public String[] getKeywordNames() {
        try {
            return (String[])this.getKeywordNames.invoke(this.library, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public Object runKeyword(String keyword, Object[] args) {
        try {
            return this.runKeyword.invoke(this.library, keyword, args);
        }
        catch (Exception e) {
            if (e.getClass().equals(InvocationTargetException.class)) {
                throw new RuntimeException(e.getCause().getMessage(), e.getCause());
            }
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public String[] getKeywordArguments(String keyword) {
        if (this.getKeywordArguments == null) {
            return new String[]{"*args"};
        }
        try {
            return (String[])this.getKeywordArguments.invoke(this.library, keyword);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public String getKeywordDocumentation(String keyword) {
        if (this.getKeywordDocumentation == null) {
            return "";
        }
        try {
            return (String)this.getKeywordDocumentation.invoke(this.library, keyword);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public String getName() {
        return this.library.getClass().getName();
    }
}

