/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.remoteserver.servlet;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.common.XmlRpcController;
import org.apache.xmlrpc.server.XmlRpcHandlerMapping;
import org.apache.xmlrpc.webserver.XmlRpcServlet;
import org.robotframework.remoteserver.RemoteServer;
import org.robotframework.remoteserver.context.Context;
import org.robotframework.remoteserver.library.DefaultRemoteLibraryFactory;
import org.robotframework.remoteserver.library.RemoteLibrary;
import org.robotframework.remoteserver.library.RemoteLibraryFactory;
import org.robotframework.remoteserver.servlet.RemoteServerRequestProcessorFactoryFactory;
import org.robotframework.remoteserver.servlet.ServerMethods;
import org.robotframework.remoteserver.xmlrpc.ReflectiveHandlerMapping;
import org.robotframework.remoteserver.xmlrpc.TypeFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteServerServlet
extends XmlRpcServlet
implements Context {
    private static final long serialVersionUID = -7981676271855172976L;
    private static String page = null;
    private static final ThreadLocal<HttpServletRequest> request = new ThreadLocal();
    private RemoteServer remoteServer;
    private SortedMap<Integer, RemoteLibrary> libraryMap;

    public RemoteServerServlet(RemoteServer remoteServer, Map<Integer, Class<?>> libraryMap) {
        this.remoteServer = remoteServer;
        RemoteLibraryFactory libraryFactory = this.createLibraryFactory();
        this.libraryMap = new TreeMap<Integer, RemoteLibrary>();
        for (Integer port : libraryMap.keySet()) {
            Object library;
            Class<?> clazz = libraryMap.get(port);
            try {
                library = clazz.newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException(String.format("Unable to create an instance of %s", clazz.getName()), e);
            }
            RemoteLibrary remoteLibrary = libraryFactory.createRemoteLibrary(library);
            this.libraryMap.put(port, remoteLibrary);
        }
    }

    protected XmlRpcHandlerMapping newXmlRpcHandlerMapping() throws XmlRpcException {
        ReflectiveHandlerMapping map = new ReflectiveHandlerMapping();
        map.setRequestProcessorFactoryFactory(new RemoteServerRequestProcessorFactoryFactory(this));
        map.addHandler("keywords", ServerMethods.class);
        map.removePrefixes();
        this.getXmlRpcServletServer().setTypeFactory((org.apache.xmlrpc.common.TypeFactory)new TypeFactory((XmlRpcController)this.getXmlRpcServletServer()));
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        request.set(req);
        try {
            super.service(req, resp);
        }
        finally {
            request.remove();
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.setContentType("text/html");
        String body = this.getPage();
        resp.setContentLength(body.length());
        PrintWriter out = resp.getWriter();
        out.print(body);
    }

    public static HttpServletRequest getRequest() {
        return request.get();
    }

    protected String getPage() {
        if (page != null) {
            return page;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 Transitional//EN\"><HTML><HEAD><TITLE>jrobotremoteserver</TITLE></HEAD><BODY><P>jrobotremoteserver serving:</P><TABLE border='1' cellspacing='0' cellpadding='5'><TR><TH>Port</TH><TH>Library</TH></TR>");
        for (Integer port : this.libraryMap.keySet()) {
            sb.append("<TR><TD>");
            sb.append(port.toString());
            sb.append("</TD><TD>");
            sb.append(StringEscapeUtils.escapeHtml((String)((RemoteLibrary)this.libraryMap.get(port)).getName()));
            sb.append("</TD></TR>");
        }
        sb.append("</TABLE></BODY></HTML>");
        page = sb.toString();
        return page;
    }

    @Override
    public RemoteLibrary getLibrary() {
        return (RemoteLibrary)this.libraryMap.get(RemoteServerServlet.getRequest().getServerPort());
    }

    protected RemoteLibraryFactory createLibraryFactory() {
        return new DefaultRemoteLibraryFactory();
    }

    @Override
    public RemoteServer getRemoteServer() {
        return this.remoteServer;
    }
}

