/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.remoteserver.servlet;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.robotframework.remoteserver.context.Context;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerMethods {
    private Log log = LogFactory.getLog(ServerMethods.class);
    private Context context;
    private static String[] ignoredExceptions = new String[]{"AssertionError", "AssertionFailedError", "Exception", "Error", "RuntimeError", "RuntimeException", "DataError", "TimeoutError", "RemoteError"};

    public ServerMethods(Context context) {
        this.context = context;
    }

    public String[] get_keyword_names() {
        try {
            String[] names = this.context.getLibrary().getKeywordNames();
            if (names == null || names.length == 0) {
                throw new RuntimeException("No keywords found in the test library");
            }
            String[] newNames = Arrays.copyOf(names, names.length + 1);
            newNames[names.length] = "stop_remote_server";
            return newNames;
        }
        catch (Throwable e) {
            this.log.warn((Object)"", e);
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> run_keyword(String keyword, Object[] args) {
        HashMap<String, Object> kr = new HashMap<String, Object>();
        PrintStream outBackup = System.out;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            System.setOut(new PrintStream((OutputStream)baos, false, "UTF-8"));
        }
        catch (UnsupportedEncodingException e2) {
            // empty catch block
        }
        try {
            kr.put("status", "PASS");
            kr.put("error", "");
            kr.put("traceback", "");
            Object retObj = "";
            if (keyword.equalsIgnoreCase("stop_remote_server")) {
                retObj = this.stopRemoteServer();
            } else {
                try {
                    retObj = this.context.getLibrary().runKeyword(keyword, args);
                }
                catch (Exception e) {
                    if (this.illegalArgumentIn(e)) {
                        for (int i = 0; i < args.length; ++i) {
                            args[i] = this.arraysToLists(args[i]);
                        }
                        retObj = this.context.getLibrary().runKeyword(keyword, args);
                    }
                    throw e;
                }
            }
            kr.put("output", baos.toString("UTF-8"));
            kr.put("return", retObj);
            HashMap<String, Object> e = kr;
            return e;
        }
        catch (Throwable e) {
            kr.put("status", "FAIL");
            try {
                kr.put("output", baos.toString("UTF-8"));
            }
            catch (UnsupportedEncodingException e1) {
                // empty catch block
            }
            kr.put("return", "");
            Throwable t = e.getCause() == null ? e : e.getCause();
            kr.put("error", this.getError(t));
            kr.put("traceback", ExceptionUtils.getStackTrace((Throwable)t));
            HashMap<String, Object> hashMap = kr;
            return hashMap;
        }
        finally {
            System.setOut(outBackup);
        }
    }

    public String[] get_keyword_arguments(String keyword) {
        if (keyword.equalsIgnoreCase("stop_remote_server")) {
            return new String[0];
        }
        try {
            String[] args = this.context.getLibrary().getKeywordArguments(keyword);
            return args == null ? new String[]{} : args;
        }
        catch (Throwable e) {
            this.log.warn((Object)"", e);
            throw new RuntimeException(e);
        }
    }

    public String get_keyword_documentation(String keyword) {
        if (keyword.equalsIgnoreCase("stop_remote_server")) {
            return "Stops the remote server.\n\nThe server may be configured so that users cannot stop it.";
        }
        try {
            String doc = this.context.getLibrary().getKeywordDocumentation(keyword);
            return doc == null ? "" : doc;
        }
        catch (Throwable e) {
            this.log.warn((Object)"", e);
            throw new RuntimeException(e);
        }
    }

    public Map<String, Object> stop_remote_server() {
        return this.run_keyword("stop_remote_server", null);
    }

    protected boolean stopRemoteServer() throws Exception {
        if (this.context.getRemoteServer().getAllowStop()) {
            System.out.print("Robot Framework remote server stopping");
            this.context.getRemoteServer().stop(2000);
        } else {
            System.out.print("This Robot Framework remote server does not allow stopping");
        }
        return true;
    }

    private String getError(Throwable thrown) {
        String simpleName = thrown.getClass().getSimpleName();
        for (String ignoredName : ignoredExceptions) {
            if (!simpleName.equals(ignoredName)) continue;
            return StringUtils.defaultIfEmpty((String)thrown.getMessage(), (String)simpleName);
        }
        return String.format("%s: %s", thrown.getClass().getName(), thrown.getMessage());
    }

    protected Object arraysToLists(Object arg) {
        if (arg instanceof Object[]) {
            Object[] array = (Object[])arg;
            List<Object> list = Arrays.asList(array);
            for (int i = 0; i < list.size(); ++i) {
                list.set(i, this.arraysToLists(list.get(i)));
            }
            return list;
        }
        if (arg instanceof Map) {
            Map oldMap = (Map)arg;
            HashMap newMap = new HashMap();
            for (Object key : oldMap.keySet()) {
                newMap.put(key, this.arraysToLists(oldMap.get(key)));
            }
            return newMap;
        }
        return arg;
    }

    private boolean illegalArgumentIn(Throwable t) {
        Throwable inner = t;
        while (inner.getCause() != null) {
            if (!(inner = inner.getCause()).getClass().equals(IllegalArgumentException.class)) continue;
            return true;
        }
        return false;
    }
}

