package demo;

import com.github.ontio.OntSdk;
import com.github.ontio.account.Account;
import com.github.ontio.common.Address;
import com.github.ontio.common.Helper;
import com.github.ontio.core.block.Block;
import com.github.ontio.core.transaction.Transaction;
import com.github.ontio.crypto.SignatureScheme;
import com.github.ontio.smartcontract.nativevm.abi.NativeBuildParams;
import com.github.ontio.smartcontract.nativevm.abi.Struct;

import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Map;

public class PutDemo {

    public static void main(String[] args) throws Exception {
        String putContract = "0000000000000000000000000000000000000008";

        OntSdk ontSdk = getOntSdk();

        String password = "passwordtest";

        if(false){
            Account sender = new Account(Helper.hexToBytes("75de8489fcb2dcaf2ef3cd607feffde18789de7da129b5e97c81e001793cb7cf"),SignatureScheme.SHA256WITHECDSA);
            Account from = new Account(Helper.hexToBytes("75de8489fcb2dcaf2ef3cd607feffde18789de7da129b5e97c81e001793cb8cf"),SignatureScheme.SHA256WITHECDSA);
            Account to = new Account(Helper.hexToBytes("75de8489fcb2dcaf2ef3cd607feffde18789de7da129b5e97c81e001793cb9cf"),SignatureScheme.SHA256WITHECDSA);
            Transaction tx = ontSdk.nativevm().ont().makeTransferFrom(sender.getAddressU160().toBase58(), from.getAddressU160().toBase58(), to.getAddressU160().toBase58(),1000000000, sender.getAddressU160().toBase58(),500,20000);
            Map res = ontSdk.parseTransaction(Helper.toHexString(tx.toArray()));
            System.out.println(tx.toHexString());
            System.out.println(res);
            return;
        }


        if(true){
            Account account = new Account(Helper.hexToBytes("75de8489fcb2dcaf2ef3cd607feffde18789de7da129b5e97c81e001793cb7cf"),SignatureScheme.SHA256WITHECDSA);
            Transaction tx = ontSdk.nativevm().ont().makeTransfer(account.getAddressU160().toBase58(), account.getAddressU160().toBase58(), 1000000000, account.getAddressU160().toBase58(),500,20000);
            Map res = ontSdk.parseTransaction(Helper.toHexString(tx.toArray()));
            System.out.println(tx.toHexString());
            System.out.println(res);
            return;

        }


        Account account5 = getAccount("IufXVQfrL3LI7g2Q7dmmsdoF7BdoI/vHIsXAxd4qkqlkGBYj3pcWHoQgdCF+iVOv","1","AZzQTkZvjy7ih9gjvwU8KYiZZyNoy6jE9p","zUtzh0B4UW0wokzL+ILdeg==");
        ontSdk.getWalletMgr().createAccountFromPriKey(password,Helper.toHexString(account5.serializePrivateKey()));
        ontSdk.getWalletMgr().writeWallet();
        System.exit(0);
        Account account1 = getAccount("YfOr9im4rOciy3cV7JkVo9QCfrRT4IGLa/CZKUJfL29pM6Zi1oVEM67+8MezMIro","1","AXmQDzzvpEtPkNwBEFsREzApTTDZFW6frD","RCIo60eCJAwzkTYmIfp3GA==");

        Account account2 = getAccount("gpgMejEHzawuXG+ghLkZ8/cQsOJcs4BsFgFjSaqE7SC8zob8hqc6cDNhJI/NBkk+","1","AY5W6p4jHeZG2jjW6nS1p4KDUhcqLkU6jz","tuLGZOimilSnypT91WrenQ==");
        Account account3 = getAccount("guffI05Eafq9F0j3/eQxHWGo1VN/xpeIkXysEPeH51C2YHYCNnCWTWAdqDB7lonl","1","ALZVrZrFqoSvqyi38n7mpPoeDp7DMtZ9b6","oZPg+5YotRWStVsRMYlhfg==");
        Account account4 = getAccount("fAknSuXzMMC0nJ2+YuTpTLs6Hl5Dc0c2zHZBd2Q7vCuv8Wt97uYz1IU0t+AtrWts","1","AMogjmLf2QohTcGST7niV75ekZfj44SKme","0BVIiUf46rb/e5dVZIwfrg==");
//        Account account5 = getAccount("IufXVQfrL3LI7g2Q7dmmsdoF7BdoI/vHIsXAxd4qkqlkGBYj3pcWHoQgdCF+iVOv","1","AZzQTkZvjy7ih9gjvwU8KYiZZyNoy6jE9p","zUtzh0B4UW0wokzL+ILdeg==");
        Account account6 = getAccount("PYEJ1c79aR7bxdzvBlj3lUMLp0VLKQHwSe+/OS1++1qa++gBMJJmJWJXUP5ZNhUs","1","AKEqQKmxCsjWJz8LPGryXzb6nN5fkK1WDY","uJhjsfcouCGZQUdHO2TZZQ==");
        Account account7 = getAccount("ZG/SfHRArUkopwhQS1MW+a0fvQvyN1NnwonU0oZH8y1bGqo5T+dQz3rz1qsXqFI2","1","AQNpGWz4oHHFBejtBbakeR43DHfen7cm8L","6qiU9bgK/+1T2V8l14mszg==");

//        Account a = getAccount("FbB9GrorxmLn7AgX6d5+/hhp6zGb7OwXzYYhbPuCqy8NvMJgTlAaRNUa4yfcG0Wf","passwordtest","AMAx993nE6NEqZjwBssUfopxnnvTdob9ij","W3i7TqkbdQ6OQineVzL47A==");
//        System.out.println("a:" + Helper.toHexString(a.serializePrivateKey()));
//
//        Account account8 = new Account(account7.serializePrivateKey(),SignatureScheme.SM3WITHSM2);
//        Account account9 = new Account(account4.serializePrivateKey(),SignatureScheme.SM3WITHSM2);
////        Address address = Address.addressFromMultiPubKeys(3,account9.serializePublicKey(),account8.serializePublicKey(),account6.serializePublicKey(),account5.serializePublicKey());
////        System.out.println("account8:" + Helper.toHexString(account8.serializePublicKey()));
////        System.out.println("account6:" + Helper.toHexString(account6.serializePublicKey()));
////        System.out.println("account5:" + Helper.toHexString(account5.serializePublicKey()));
//
////        System.out.println("address:" + address.toBase58());
        Address address = Address.addressFromMultiPubKeys(5,account1.serializePublicKey(),account2.serializePublicKey(),account3.serializePublicKey(),account4.serializePublicKey(),account5.serializePublicKey(),account6.serializePublicKey(),account7.serializePublicKey());

////        account1 = new Account(Helper.hexToBytes("75de8489fcb2dcaf2ef3cd607feffde18789de7da129b5e97c81e001793cb7cf"),SignatureScheme.SHA256WITHECDSA);
//        System.out.println(ontSdk.getConnect().getBlockHeight());
        System.out.println("address：" + ontSdk.getConnect().getBalance(address.toBase58()));
//        System.out.println("account1：" +ontSdk.getConnect().getBalance(account1.getAddressU160().toBase58()));
//        System.out.println("account1 ong：" +ontSdk.nativevm().ong().unboundOng(account1.getAddressU160().toBase58()));
////        String txhash = ontSdk.nativevm().ong().withdrawOng(account1,account1.getAddressU160().toBase58(),16930000000L,account1,ontSdk.DEFAULT_GAS_LIMIT,0);
//
////        String txhash = ontSdk.nativevm().ont().sendTransfer(account1,address.toBase58(),60000000,account1,ontSdk.DEFAULT_GAS_LIMIT,0);
//
        com.github.ontio.account.Account[] accounts = new com.github.ontio.account.Account[]{account1,account2,account3,account4,account5,account6,account7};
        byte[][] pks = new byte[accounts.length][];
        for(int i=0;i<pks.length;i++){
            pks[i] = accounts[i].serializePublicKey();
        }

        Transaction tx = ontSdk.nativevm().ont().makeTransfer(address.toBase58(),account1.getAddressU160().toBase58(),900,account1.getAddressU160().toBase58(),ontSdk.DEFAULT_GAS_LIMIT,0);
        ontSdk.addMultiSign(tx,5,pks,account1);
        ontSdk.addMultiSign(tx,5,pks,account2);
        ontSdk.addMultiSign(tx,5,pks,account3);
        ontSdk.addMultiSign(tx,5,pks,account4);
        ontSdk.addMultiSign(tx,5,pks,account5);
        ontSdk.addSign(tx,account1);
//        ontSdk.signTx(tx,new Account[][]{{account1}});
//        ontSdk.addMultiSign(tx,2,new Account[]{account8,account6,account5});
        boolean b = ontSdk.getConnect().sendRawTransaction(tx);
//
        String txhash = tx.hash().toHexString();


        Thread.sleep(6000);
        System.out.println("txhash:" + txhash);
        System.out.println(ontSdk.getConnect().getSmartCodeEvent(txhash));
//
        System.out.println("address：" +ontSdk.getConnect().getBalance(address.toBase58()));
//        System.out.println("account1：" +ontSdk.getConnect().getBalance(account1.getAddressU160().toBase58()));
//
//        Transaction tx2 = ontSdk.getConnect().getTransaction(txhash);


    }

    public static Account getAccount(String enpri,String password,String address,String salt) throws Exception {
        String privateKey = Account.getGcmDecodedPrivateKey(enpri,password,address,Base64.getDecoder().decode(salt),16384,SignatureScheme.SHA256WITHECDSA);
        Account account = new Account(Helper.hexToBytes(privateKey),SignatureScheme.SM3WITHSM2);
//        System.out.println(Helper.toHexString(account.serializePublicKey()));
        return account;
    }


    public static OntSdk getOntSdk() throws Exception {

//        String ip = "http://127.0.0.1";
//        String ip = "http://139.219.129.55";
//        String ip = "http://101.132.193.149";
        String ip = "http://polaris1.ont.io";
        String restUrl = ip + ":" + "20334";
        String rpcUrl = ip + ":" + "20336";
        String wsUrl = ip + ":" + "20335";


        OntSdk wm = OntSdk.getInstance();
        wm.setRpc(rpcUrl);
        wm.setRestful(restUrl);
        wm.setDefaultConnect(wm.getRestful());
        wm.openWalletFile("Wallet5.json");
        return wm;
    }
}
