/*
 * Decompiled with CFR 0.152.
 */
package org.arl.fjage;

import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Stack;
import java.util.TimerTask;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.arl.fjage.AgentID;
import org.arl.fjage.AgentLocalRandom;
import org.arl.fjage.AgentState;
import org.arl.fjage.Behavior;
import org.arl.fjage.Container;
import org.arl.fjage.FjageException;
import org.arl.fjage.LogHandlerProxy;
import org.arl.fjage.Message;
import org.arl.fjage.MessageFilter;
import org.arl.fjage.MessageQueue;
import org.arl.fjage.Messenger;
import org.arl.fjage.Platform;
import org.arl.fjage.RequestSender;
import org.arl.fjage.TimestampProvider;
import org.arl.fjage.WakerBehavior;
import org.arl.fjage.persistence.Store;
import org.arl.fjage.remote.SlaveContainer;

public class Agent
implements Runnable,
TimestampProvider,
Messenger {
    public static final long NON_BLOCKING = 0L;
    public static final long BLOCKING = -1L;
    protected static final Level ALL = Level.ALL;
    protected static final Level FINEST = Level.FINEST;
    protected static final Level FINER = Level.FINER;
    protected static final Level FINE = Level.FINE;
    protected static final Level INFO = Level.INFO;
    protected static final Level WARNING = Level.WARNING;
    protected static final Level SEVERE = Level.SEVERE;
    protected static final Level OFF = Level.OFF;
    private AgentID aid = null;
    private volatile AgentState state = AgentState.INIT;
    private volatile AgentState oldState = AgentState.NONE;
    private Queue<Behavior> newBehaviors = new ArrayDeque<Behavior>();
    private Queue<Behavior> activeBehaviors = new PriorityQueue<Behavior>();
    private Queue<Behavior> blockedBehaviors = new ArrayDeque<Behavior>();
    private Stack<MessageFilter> exclusions = new Stack();
    private volatile boolean restartBehaviors = false;
    private boolean unblocked = false;
    private Platform platform = null;
    private Container container = null;
    private MessageQueue queue = new MessageQueue(256);
    private boolean yieldDuringReceive = false;
    protected long tid = -1L;
    protected Thread thread = null;
    protected boolean ignoreExceptions = false;
    protected Logger log = Logger.getLogger(this.getClass().getName());

    protected void init() {
    }

    protected void shutdown() {
    }

    protected void die(Throwable ex) {
    }

    public AgentID getAgentID() {
        return this.aid;
    }

    public String getName() {
        if (this.aid == null) {
            return null;
        }
        return this.aid.getName();
    }

    public void setLogLevel(Level level) {
        this.log.setLevel(level);
    }

    protected synchronized void block() {
        if (this.state == AgentState.FINISHING) {
            return;
        }
        if (!this.unblocked) {
            this.unblocked = true;
            if (this.restartBehaviors) {
                return;
            }
            for (Behavior b : this.blockedBehaviors) {
                if (b.isBlocked()) continue;
                return;
            }
        }
        this.unblocked = false;
        this.oldState = this.state;
        this.state = AgentState.IDLE;
        this.container.reportIdle(this.aid);
        try {
            this.wait();
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
        if (this.state == AgentState.IDLE) {
            this.log.info("block() interrupted");
            if (this.oldState != AgentState.NONE) {
                this.state = this.oldState;
                if (this.container != null) {
                    this.container.reportBusy(this.aid);
                }
                this.oldState = AgentState.NONE;
            }
        }
    }

    protected void block(long millis) {
        this.platform.schedule(new TimerTask(){

            @Override
            public void run() {
                Agent.this.wake();
            }
        }, millis);
        this.block();
    }

    protected void delay(long millis) {
        long t = this.currentTimeMillis() + millis;
        long dt = millis;
        while (dt > 0L) {
            this.block(dt);
            dt = t - this.currentTimeMillis();
        }
    }

    public synchronized void wake() {
        if (this.oldState != AgentState.NONE) {
            this.state = this.oldState;
            if (this.container != null) {
                this.container.reportBusy(this.aid);
            }
            this.oldState = AgentState.NONE;
        }
        this.notify();
    }

    public void stop() {
        if (this.state == AgentState.FINISHED || this.state == AgentState.FINISHING) {
            return;
        }
        this.state = this.oldState = AgentState.FINISHING;
        if (this.container != null) {
            this.container.reportBusy(this.aid);
        }
        this.wake();
    }

    public synchronized Behavior add(Behavior b) {
        b.setOwner(this);
        this.newBehaviors.add(b);
        this.wake();
        return b;
    }

    public AgentState getState() {
        return this.state;
    }

    public Platform getPlatform() {
        return this.platform;
    }

    public Container getContainer() {
        return this.container;
    }

    @Override
    public long currentTimeMillis() {
        return this.platform.currentTimeMillis();
    }

    @Override
    public long nanoTime() {
        return this.platform.nanoTime();
    }

    public AgentID agent(String name) {
        return new AgentID(name, (Messenger)this);
    }

    public AgentID topic(String topic) {
        return new AgentID(topic, true, this);
    }

    public AgentID topic(Enum<?> topic) {
        return new AgentID(topic.getClass().getName() + "." + topic.toString(), true, this);
    }

    public AgentID topic(AgentID agent) {
        if (agent.isTopic()) {
            return agent;
        }
        return new AgentID(agent.getName() + "__ntf", true, this);
    }

    public AgentID topic(AgentID agent, String topic) {
        return new AgentID(agent.getName() + "__" + topic + "__ntf", true, this);
    }

    public AgentID topic(AgentID agent, Enum<?> topic) {
        return new AgentID(agent.getName() + "__" + topic.getClass().getName() + "." + topic.toString() + "__ntf", true, this);
    }

    public AgentID topic() {
        if (this.aid == null) {
            return null;
        }
        return new AgentID(this.aid.getName() + "__ntf", true, this);
    }

    @Override
    public boolean send(Message m) {
        if (this.container == null) {
            return false;
        }
        m.setSender(this.aid);
        return this.container.send(m);
    }

    public RequestSender prepareRequest(Message request) {
        return new InternalRequestSender(request);
    }

    public void platformSend(Message m) {
        m.setSender(this.aid);
        for (Container c : this.platform.getContainers()) {
            c.send(m);
        }
    }

    protected void setYieldDuringReceive(boolean b) {
        this.yieldDuringReceive = b;
    }

    protected boolean getYieldDuringReceive() {
        return this.yieldDuringReceive;
    }

    @Override
    public Message receive(MessageFilter filter, long timeout) {
        Message m;
        if (Thread.currentThread().getId() != this.tid) {
            throw new FjageException("receive() should only be called from agent thread");
        }
        long deadline = 0L;
        if (timeout != 0L) {
            this.queue.commit(this.exclusions);
        }
        if ((m = this.queue.get(filter)) == null && timeout != 0L) {
            if (timeout != -1L) {
                deadline = this.currentTimeMillis() + timeout;
            }
            do {
                this.exclusions.push(filter);
                if (timeout == -1L) {
                    if (!this.yieldDuringReceive || !this.executeBehavior()) {
                        this.block();
                    }
                } else if (!this.yieldDuringReceive || !this.executeBehavior()) {
                    long t = deadline - this.currentTimeMillis();
                    this.block(t);
                }
                this.exclusions.pop();
                if (Thread.interrupted()) {
                    return null;
                }
                if (this.state == AgentState.FINISHING) {
                    return null;
                }
                this.queue.commit(this.exclusions);
            } while ((m = this.queue.get(filter)) == null && (timeout == -1L || this.currentTimeMillis() < deadline));
        }
        return m;
    }

    @Override
    public Message receive(MessageFilter filter) {
        return this.receive(filter, 0L);
    }

    @Override
    public Message receive() {
        return this.receive((MessageFilter)null, 0L);
    }

    @Override
    public Message receive(long timeout) {
        return this.receive((MessageFilter)null, timeout);
    }

    @Override
    public Message receive(Class<?> cls) {
        return this.receive(cls, 0L);
    }

    @Override
    public Message receive(Class<?> cls, long timeout) {
        return this.receive((Message m) -> cls.isInstance(m), timeout);
    }

    @Override
    public Message receive(Message m) {
        return this.receive(m, 0L);
    }

    @Override
    public Message receive(final Message m, long timeout) {
        Message rsp;
        if (this.container instanceof SlaveContainer) {
            ((SlaveContainer)this.container).checkAuthFailure(m.getMessageID());
        }
        if ((rsp = this.receive(new MessageFilter(){
            private String mid;
            {
                this.mid = m.getMessageID();
            }

            @Override
            public boolean matches(Message m2) {
                String s = m2.getInReplyTo();
                if (s == null) {
                    return false;
                }
                return s.equals(this.mid);
            }
        }, timeout)) != null) {
            return rsp;
        }
        if (this.container instanceof SlaveContainer) {
            ((SlaveContainer)this.container).checkAuthFailure(m.getMessageID());
        }
        return null;
    }

    @Override
    public Message request(Message msg, long timeout) {
        if (Thread.currentThread().getId() != this.tid) {
            throw new FjageException("request() should only be called from agent thread " + this.tid + ", but called from " + Thread.currentThread().getId());
        }
        if (!this.send(msg)) {
            return null;
        }
        return this.receive(msg, timeout);
    }

    @Override
    public Message request(Message msg) {
        return this.request(msg, 1000L);
    }

    public void setQueueSize(int size) {
        this.queue.setSize(size);
    }

    public boolean subscribe(AgentID topic) {
        return this.container.subscribe(this.aid, topic);
    }

    public boolean unsubscribe(AgentID topic) {
        return this.container.unsubscribe(this.aid, topic);
    }

    public boolean register(String service) {
        return this.container.register(this.aid, service);
    }

    public boolean register(Enum<?> service) {
        return this.container.register(this.aid, service.getClass().getName() + "." + service.toString());
    }

    public boolean deregister(String service) {
        return this.container.deregister(this.aid, service);
    }

    public boolean deregister(Enum<?> service) {
        return this.container.deregister(this.aid, service.getClass().getName() + "." + service.toString());
    }

    public AgentID agentForService(String service) {
        AgentID a = this.container.agentForService(service);
        if (a != null) {
            a = new AgentID(a, (Messenger)this);
        }
        return a;
    }

    public AgentID agentForService(Enum<?> service) {
        AgentID a = this.container.agentForService(service.getClass().getName() + "." + service.toString());
        if (a != null) {
            a = new AgentID(a, (Messenger)this);
        }
        return a;
    }

    public AgentID[] agentsForService(String service) {
        AgentID[] a = this.container.agentsForService(service);
        if (a != null) {
            for (int i = 0; i < a.length; ++i) {
                a[i] = new AgentID(a[i], (Messenger)this);
            }
        }
        return a;
    }

    public AgentID[] agentsForService(Enum<?> service) {
        AgentID[] a = this.container.agentsForService(service.getClass().getName() + "." + service.toString());
        if (a != null) {
            for (int i = 0; i < a.length; ++i) {
                a[i] = new AgentID(a[i], (Messenger)this);
            }
        }
        return a;
    }

    public void println(Object msg) {
        this.log.info(msg.toString());
    }

    public Store getStore() {
        return Store.getInstance(this);
    }

    public <T extends Serializable> T clone(T obj) {
        return this.container.clone(obj);
    }

    public String toString() {
        if (this.aid != null) {
            return this.aid.toString();
        }
        return this.getClass().getName() + "@" + this.hashCode();
    }

    final void bind(AgentID aid, Container container) {
        String cname;
        this.aid = aid;
        this.container = container;
        Platform platform = this.platform = container == null ? null : container.getPlatform();
        if (container != null && (cname = container.getName()) != null && !cname.startsWith("@")) {
            this.log = Logger.getLogger(this.getClass().getName() + "/" + container.getName());
        }
        LogHandlerProxy.install(this.platform, this.log);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void deliver(Message m) {
        if (this.container == null) {
            return;
        }
        this.log.finer("MSG " + m.getSender() + " > " + this.aid + "@" + this.tid + " : " + m.toString());
        this.queue.add(this.container.autoclone(m));
        Agent agent = this;
        synchronized (agent) {
            this.restartBehaviors = true;
            this.unblocked = false;
            this.wake();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean executeBehavior() {
        Agent agent;
        if (this.restartBehaviors) {
            agent = this;
            synchronized (agent) {
                this.restartBehaviors = false;
                this.activeBehaviors.addAll(this.blockedBehaviors);
                this.blockedBehaviors.clear();
                this.queue.commit(this.exclusions);
            }
        } else {
            Iterator iterator = this.blockedBehaviors.iterator();
            while (iterator.hasNext()) {
                Behavior b = (Behavior)iterator.next();
                if (b.isBlocked()) continue;
                iterator.remove();
                this.activeBehaviors.add(b);
            }
        }
        try {
            Behavior b = this.newBehaviors.poll();
            if (b != null) {
                this.activeBehaviors.add(b);
                b.onStart();
                return true;
            }
            b = this.activeBehaviors.poll();
            if (b != null) {
                b.unblock();
                b.action();
                if (b.done()) {
                    b.onEnd();
                    b.setOwner(null);
                } else if (b.isBlocked()) {
                    this.blockedBehaviors.add(b);
                } else {
                    this.activeBehaviors.add(b);
                }
                return true;
            }
        }
        catch (Throwable ex) {
            if (this.ignoreExceptions) {
                this.log.log(Level.WARNING, "Exception in agent: " + this.aid, ex);
            }
            throw ex;
        }
        agent = this;
        synchronized (agent) {
            return this.newBehaviors.size() > 0;
        }
    }

    @Override
    public final void run() {
        this.thread = Thread.currentThread();
        this.tid = this.thread.getId();
        this.state = AgentState.RUNNING;
        this.container.reportBusy(this.aid);
        try {
            this.init();
            while (!this.container.isRunning()) {
                this.block();
                Thread.interrupted();
            }
            while (this.state != AgentState.FINISHING) {
                if (!this.executeBehavior()) {
                    this.block();
                }
                Thread.interrupted();
            }
        }
        catch (Throwable ex) {
            this.log.log(Level.SEVERE, "Exception in agent: " + this.aid, ex);
            this.die(ex);
        }
        this.state = AgentState.RUNNING;
        this.container.reportBusy(this.aid);
        try {
            this.shutdown();
        }
        catch (Throwable ex) {
            this.log.log(Level.SEVERE, "Exception in agent: " + this.aid, ex);
        }
        this.state = AgentState.FINISHED;
        this.container.reportIdle(this.aid);
        this.container.kill(this.aid);
        AgentLocalRandom.unbind();
        this.container = null;
        this.platform = null;
    }

    private class InternalRequestSender
    implements RequestSender {
        private final Message request;
        private List<Consumer<Message>> onAgreeList;
        private List<Consumer<Message>> onRefuseList;
        private List<Consumer<Message>> onFailureList;
        private List<Consumer<Message>> onInformList;
        private List<Consumer<Message>> otherwiseList;
        private List<TimeoutEntry> onTimeoutList;
        private List<WakerBehavior> timeoutBehaviorList;
        private StoppableMessageBehavior messageBehavior;
        private volatile Message message;
        private volatile boolean done = false;
        private volatile boolean cancelled = false;

        private InternalRequestSender(Message request) {
            this.request = request;
        }

        private <T> List<T> addHandler(List<T> handlerList, T handler) {
            if (handlerList == null) {
                handlerList = new ArrayList<T>();
            }
            handlerList.add(handler);
            return handlerList;
        }

        @Override
        public RequestSender onAgree(Consumer<Message> consumer) {
            this.onAgreeList = this.addHandler(this.onAgreeList, consumer);
            return this;
        }

        @Override
        public RequestSender onRefuse(Consumer<Message> consumer) {
            this.onRefuseList = this.addHandler(this.onRefuseList, consumer);
            return this;
        }

        @Override
        public RequestSender onFailure(Consumer<Message> consumer) {
            this.onFailureList = this.addHandler(this.onFailureList, consumer);
            return this;
        }

        @Override
        public RequestSender onInform(Consumer<Message> consumer) {
            this.onInformList = this.addHandler(this.onInformList, consumer);
            return this;
        }

        @Override
        public RequestSender otherwise(Consumer<Message> consumer) {
            this.otherwiseList = this.addHandler(this.otherwiseList, consumer);
            return this;
        }

        @Override
        public RequestSender onTimeout(long timeout, Runnable runnable) {
            if (this.onTimeoutList == null) {
                this.onTimeoutList = new ArrayList<TimeoutEntry>();
            }
            this.onTimeoutList.add(new TimeoutEntry(timeout, runnable));
            return this;
        }

        @Override
        public Future<Message> send() {
            if (this.onTimeoutList != null && !this.onTimeoutList.isEmpty()) {
                this.timeoutBehaviorList = new ArrayList<WakerBehavior>();
                for (final TimeoutEntry timeoutEntry : this.onTimeoutList) {
                    WakerBehavior timeoutBehavior = new WakerBehavior(timeoutEntry.getTimeout()){

                        @Override
                        public void onWake() {
                            if (InternalRequestSender.this.done) {
                                return;
                            }
                            InternalRequestSender.this.done = true;
                            try {
                                timeoutEntry.getRunnable().run();
                            }
                            catch (Throwable t) {
                                this.log.log(Level.WARNING, "Exception", t);
                            }
                            InternalRequestSender.this.stopBehaviors();
                        }
                    };
                    this.timeoutBehaviorList.add(timeoutBehavior);
                    Agent.this.add(timeoutBehavior);
                }
            }
            this.messageBehavior = new StoppableMessageBehavior(new ReplyMessageFilter(this.request)){

                @Override
                public void onReceive(Message message) {
                    if (InternalRequestSender.this.done) {
                        return;
                    }
                    if (this.done()) {
                        return;
                    }
                    switch (message.getPerformative()) {
                        case AGREE: {
                            InternalRequestSender.this.consumeMessageAndMarkAsDone(InternalRequestSender.this.onAgreeList, message);
                            break;
                        }
                        case REFUSE: {
                            InternalRequestSender.this.consumeMessageAndMarkAsDone(InternalRequestSender.this.onRefuseList, message);
                            break;
                        }
                        case FAILURE: {
                            InternalRequestSender.this.consumeMessageAndMarkAsDone(InternalRequestSender.this.onFailureList, message);
                            break;
                        }
                        case INFORM: {
                            InternalRequestSender.this.consumeMessageAndMarkAsDone(InternalRequestSender.this.onInformList, message);
                            break;
                        }
                        default: {
                            InternalRequestSender.this.consumeMessageAndMarkAsDone(InternalRequestSender.this.otherwiseList, message);
                        }
                    }
                }
            };
            Agent.this.add(this.messageBehavior);
            Agent.this.send(this.request);
            return new MessageFuture();
        }

        @Override
        public Message sendAndWait() {
            Future<Message> future = this.send();
            try {
                return future.get();
            }
            catch (InterruptedException | ExecutionException e) {
                return null;
            }
        }

        private void stopBehaviors() {
            if (this.timeoutBehaviorList != null) {
                for (WakerBehavior timeoutBehavior : this.timeoutBehaviorList) {
                    timeoutBehavior.stop();
                }
            }
            if (this.messageBehavior != null) {
                this.messageBehavior.stop();
            }
        }

        private void consumeMessageAndMarkAsDone(List<Consumer<Message>> consumers, Message message) {
            if (this.done || consumers == null || consumers.isEmpty()) {
                return;
            }
            this.message = message;
            this.done = true;
            this.consumeMessage(consumers, message);
        }

        private void consumeMessage(List<Consumer<Message>> consumers, Message message) {
            if (consumers == null || consumers.isEmpty()) {
                return;
            }
            for (Consumer<Message> consumer : consumers) {
                if (consumer == null) continue;
                try {
                    consumer.accept(message);
                }
                catch (Throwable t) {
                    Agent.this.log.log(Level.WARNING, "Exception", t);
                }
            }
        }

        private class StoppableMessageBehavior
        extends Behavior {
            private final MessageFilter filter;
            private boolean quit = false;

            public StoppableMessageBehavior() {
                this((MessageFilter)null);
            }

            public StoppableMessageBehavior(Class<?> cls) {
                this(cls::isInstance);
            }

            public StoppableMessageBehavior(MessageFilter filter) {
                this.filter = filter;
            }

            public boolean accepts(Message msg) {
                if (this.filter == null) {
                    return true;
                }
                return this.filter.matches(msg);
            }

            public void onReceive(Message msg) {
                if (this.action != null) {
                    this.action.call(msg);
                }
            }

            @Override
            public final void action() {
                Message msg = this.filter == null ? this.agent.receive() : this.agent.receive(this.filter, 0L);
                if (msg == null) {
                    this.block();
                } else {
                    this.onReceive(msg);
                }
            }

            public final void stop() {
                this.quit = true;
            }

            @Override
            public final boolean done() {
                return this.quit;
            }

            @Override
            public int getPriority() {
                if (this.filter != null) {
                    return -100;
                }
                return 0;
            }
        }

        private class ReplyMessageFilter
        implements MessageFilter {
            private final String messageId;

            public ReplyMessageFilter(Message request) {
                this.messageId = request.getMessageID();
                if (this.messageId == null) {
                    throw new IllegalArgumentException("Message does not have an ID");
                }
            }

            @Override
            public boolean matches(Message message) {
                return message.getInReplyTo() != null && message.getInReplyTo().equals(this.messageId);
            }
        }

        private class TimeoutEntry {
            private final long timeout;
            private final Runnable runnable;

            public TimeoutEntry(long timeout, Runnable runnable) {
                this.timeout = timeout;
                this.runnable = runnable;
            }

            public long getTimeout() {
                return this.timeout;
            }

            public Runnable getRunnable() {
                return this.runnable;
            }
        }

        private class MessageFuture
        implements Future<Message> {
            private MessageFuture() {
            }

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                if (InternalRequestSender.this.done) {
                    return false;
                }
                try {
                    InternalRequestSender.this.stopBehaviors();
                    boolean bl = true;
                    return bl;
                }
                finally {
                    InternalRequestSender.this.cancelled = true;
                    InternalRequestSender.this.done = true;
                }
            }

            @Override
            public boolean isCancelled() {
                return InternalRequestSender.this.cancelled;
            }

            @Override
            public boolean isDone() {
                return InternalRequestSender.this.done;
            }

            @Override
            public Message get() throws InterruptedException, ExecutionException {
                try {
                    return this.doGet(0L, null);
                }
                catch (TimeoutException e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public Message get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                if (unit == null) {
                    throw new NullPointerException();
                }
                return this.doGet(timeout, unit);
            }

            private Message doGet(long timeout, TimeUnit unit) throws TimeoutException {
                Long deadline;
                if (Thread.currentThread().getId() != Agent.this.tid) {
                    throw new FjageException("receive() should only be called from agent thread");
                }
                Long timeoutMs = unit != null ? Long.valueOf(TimeUnit.MILLISECONDS.convert(timeout, unit)) : null;
                Long l = deadline = timeoutMs != null ? Long.valueOf(Agent.this.currentTimeMillis() + timeoutMs) : null;
                while (!(Agent.this.getState() == AgentState.FINISHING || InternalRequestSender.this.done || deadline != null && Agent.this.currentTimeMillis() >= deadline)) {
                    if (!Agent.this.executeBehavior()) {
                        Agent.this.block();
                    }
                    Thread.interrupted();
                }
                if (deadline != null && Agent.this.currentTimeMillis() >= deadline) {
                    throw new TimeoutException();
                }
                return InternalRequestSender.this.message;
            }
        }
    }
}

