/*
 * Decompiled with CFR 0.152.
 */
package org.arl.fjage;

import java.io.Serializable;
import org.arl.fjage.Message;
import org.arl.fjage.Messenger;
import org.arl.fjage.param.Parameter;
import org.arl.fjage.param.ParameterReq;
import org.arl.fjage.param.ParameterRsp;

public class AgentID
implements Serializable,
Comparable<AgentID> {
    private static final long serialVersionUID = 1L;
    private String name;
    private boolean isTopic;
    private transient Messenger owner;

    public AgentID(String name) {
        this.name = name;
        this.isTopic = false;
        this.owner = null;
    }

    public AgentID(String name, boolean isTopic) {
        this.name = name;
        this.isTopic = isTopic;
        this.owner = null;
    }

    public AgentID(String name, Messenger owner) {
        this.name = name;
        this.isTopic = false;
        this.owner = owner;
    }

    public AgentID(String name, boolean isTopic, Messenger owner) {
        this.name = name;
        this.isTopic = isTopic;
        this.owner = owner;
    }

    public AgentID(AgentID aid, Messenger owner) {
        this.name = aid.name;
        this.isTopic = aid.isTopic;
        this.owner = owner;
    }

    public boolean isTopic() {
        return this.isTopic;
    }

    public String getName() {
        return this.name;
    }

    public Messenger getOwner() {
        return this.owner;
    }

    public void send(Message msg) {
        msg.setRecipient(this);
        this.owner.send(msg);
    }

    public Message request(Message msg) {
        msg.setRecipient(this);
        return this.owner.request(msg, 1000L);
    }

    public Message request(Message msg, long timeout) {
        msg.setRecipient(this);
        return this.owner.request(msg, timeout);
    }

    public Object get(Parameter param) {
        return this.get(param, -1);
    }

    public Object get(Parameter param, int ndx) {
        Message rsp;
        if (param == null) {
            return null;
        }
        ParameterReq req = new ParameterReq(this).get(param);
        if (ndx >= 0) {
            req.setIndex(ndx);
        }
        if ((rsp = this.request(req)) == null) {
            return null;
        }
        if (!(rsp instanceof ParameterRsp)) {
            return null;
        }
        return ((ParameterRsp)rsp).get(param);
    }

    public Object set(Parameter param, Object value) {
        return this.set(param, value, -1);
    }

    public Object set(Parameter param, Object value, int ndx) {
        Message rsp;
        if (param == null) {
            return null;
        }
        ParameterReq req = new ParameterReq(this).set(param, value);
        if (ndx >= 0) {
            req.setIndex(ndx);
        }
        if ((rsp = this.request(req)) == null) {
            return null;
        }
        if (!(rsp instanceof ParameterRsp)) {
            return null;
        }
        return ((ParameterRsp)rsp).get(param);
    }

    public String toString() {
        return this.name;
    }

    public int hashCode() {
        return ((this.isTopic ? "!" : "[") + this.name).hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof String) {
            return this.name.equals(obj);
        }
        if (!(obj instanceof AgentID)) {
            return false;
        }
        AgentID a = (AgentID)obj;
        if (!this.name.equals(a.name)) {
            return false;
        }
        return this.isTopic == a.isTopic;
    }

    @Override
    public int compareTo(AgentID aid) {
        if (this.equals(aid)) {
            return 0;
        }
        if (this.hashCode() < aid.hashCode()) {
            return -1;
        }
        return 1;
    }
}

