/*
 * Decompiled with CFR 0.152.
 */
package org.arl.fjage;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.logging.Logger;
import org.arl.fjage.Agent;

public class AgentLocalRandom
extends Random {
    private static final long serialVersionUID = 1L;
    private static Logger log = Logger.getLogger(AgentLocalRandom.class.getName());
    private static AgentLocalRandom root = new AgentLocalRandom();
    private static Map<Object, AgentLocalRandom> rng = Collections.synchronizedMap(new HashMap());

    public static AgentLocalRandom current() {
        Thread tid = Thread.currentThread();
        AgentLocalRandom r = rng.get(tid);
        if (r != null) {
            return r;
        }
        return root;
    }

    static void bind(Agent agent) {
        AgentLocalRandom r = new AgentLocalRandom();
        long seed = root.nextLong();
        r.setSeed(seed);
        rng.put(agent, r);
    }

    static void bind(Agent agent, Thread tid) {
        AgentLocalRandom r = rng.get(agent);
        if (r != null) {
            rng.put(tid, r);
            rng.remove(agent);
        }
    }

    static void unbind(Thread tid) {
        rng.remove(tid);
    }

    static void unbind() {
        AgentLocalRandom.unbind(Thread.currentThread());
    }

    public static void setRootSeed(long seed) {
        root.setSeed(seed);
        rng.clear();
    }

    @Override
    public double nextDouble(double min, double max) {
        return this.nextDouble() * (max - min) + min;
    }

    public double nextExp(double lambda) {
        return this.nextExp() / lambda;
    }

    public double nextExp() {
        double r = -Math.log(this.nextDouble());
        return r;
    }

    @Override
    public double nextGaussian(double mu, double sigma2) {
        return this.nextGaussian() * Math.sqrt(sigma2) + mu;
    }

    public double nextRayleigh(double sigma) {
        return Math.sqrt(-2.0 * Math.log(this.nextDouble())) * sigma;
    }

    public double nextRician(double nu, double sigma) {
        return Math.sqrt(Math.pow(this.nextGaussian() * sigma + nu, 2.0) + Math.pow(this.nextGaussian() * sigma, 2.0));
    }
}

