/*
 * Decompiled with CFR 0.152.
 */
package org.arl.fjage;

import org.arl.fjage.Behavior;

public class BackoffBehavior
extends Behavior {
    private long period;
    private long wakeupTime;
    private boolean quit;

    public BackoffBehavior(long millis) {
        this.period = millis;
        this.quit = false;
    }

    public BackoffBehavior(long millis, Runnable runnable) {
        this(millis);
        if (runnable != null) {
            this.action = param -> runnable.run();
        }
    }

    public final void stop() {
        this.quit = true;
    }

    protected void backoff(long millis) {
        this.quit = false;
        this.period = millis;
    }

    public void onExpiry() {
        super.action();
    }

    @Override
    public void onStart() {
        this.wakeupTime = this.agent.currentTimeMillis() + this.period;
        this.block(this.period);
    }

    @Override
    public final void action() {
        if (this.quit) {
            return;
        }
        long t = this.agent.currentTimeMillis();
        long dt = this.wakeupTime - t;
        if (dt > 0L) {
            this.block(dt);
        } else {
            this.quit = true;
            this.onExpiry();
            if (!this.quit) {
                this.wakeupTime += this.period;
                if (this.wakeupTime < t) {
                    this.wakeupTime = t + this.period;
                }
            }
        }
    }

    @Override
    public final boolean done() {
        return this.quit;
    }

    @Override
    public void reset() {
        super.reset();
        this.quit = false;
    }
}

