/*
 * Decompiled with CFR 0.152.
 */
package org.arl.fjage;

import java.util.TimerTask;
import java.util.logging.Logger;
import org.arl.fjage.Agent;
import org.arl.fjage.AgentID;
import org.arl.fjage.Callback;
import org.arl.fjage.Messenger;

public class Behavior
implements Comparable<Behavior> {
    protected Agent agent;
    protected Logger log;
    protected Callback action = null;
    private volatile boolean blocked = false;

    public void onStart() {
    }

    public void onEnd() {
    }

    public void action() {
        if (this.action != null) {
            this.action.call(null);
        }
    }

    public boolean done() {
        return true;
    }

    public int getPriority() {
        return 0;
    }

    @Override
    public int compareTo(Behavior obj) {
        return Integer.compare(this.getPriority(), obj.getPriority());
    }

    public void block() {
        this.blocked = true;
    }

    public void block(long millis) {
        this.blocked = true;
        this.agent.getPlatform().schedule(new TimerTask(){

            @Override
            public void run() {
                Behavior.this.restart();
            }
        }, millis);
    }

    public synchronized void restart() {
        this.blocked = false;
        if (this.agent != null) {
            this.agent.wake();
        }
    }

    void unblock() {
        this.blocked = false;
    }

    public boolean isBlocked() {
        return this.blocked;
    }

    public void reset() {
        this.blocked = false;
    }

    public AgentID agent(String name) {
        return new AgentID(name, (Messenger)this.agent);
    }

    public AgentID agentForService(String service) {
        return this.agent.agentForService(service);
    }

    public AgentID agentForService(Enum<?> service) {
        return this.agent.agentForService(service);
    }

    public AgentID[] agentsForService(String service) {
        return this.agent.agentsForService(service);
    }

    public AgentID[] agentsForService(Enum<?> service) {
        return this.agent.agentsForService(service);
    }

    public void println(String msg) {
        this.log.info(msg);
    }

    synchronized void setOwner(Agent agent) {
        this.agent = agent;
        this.log = agent == null ? null : agent.log;
    }
}

