/*
 * Decompiled with CFR 0.152.
 */
package org.arl.fjage;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import org.arl.fjage.Agent;
import org.arl.fjage.AgentID;
import org.arl.fjage.AgentLocalRandom;
import org.arl.fjage.AgentState;
import org.arl.fjage.FjageException;
import org.arl.fjage.LogHandlerProxy;
import org.arl.fjage.Message;
import org.arl.fjage.MessageListener;
import org.arl.fjage.Platform;

public class Container {
    public static final String SERIAL_CLONER = "org.apache.commons.lang3.SerializationUtils";
    public static final String FAST_CLONER = "com.rits.cloning.Cloner";
    protected String name;
    protected Platform platform;
    protected Map<AgentID, Agent> agents = new ConcurrentHashMap<AgentID, Agent>();
    protected Map<AgentID, Agent> agentsToAdd = new ConcurrentHashMap<AgentID, Agent>();
    protected Map<AgentID, Set<Agent>> topics = new HashMap<AgentID, Set<Agent>>();
    protected Map<String, Set<AgentID>> services = new HashMap<String, Set<AgentID>>();
    protected Logger log = Logger.getLogger(this.getClass().getName());
    protected boolean running = false;
    protected boolean initing = false;
    protected Object cloner;
    protected Method doClone;
    protected boolean autoclone = false;
    protected Set<AgentID> idle = new HashSet<AgentID>();
    protected Set<MessageListener> listeners = new HashSet<MessageListener>();

    public Container(Platform platform) {
        this.name = "@" + Integer.toHexString(this.hashCode());
        this.platform = platform;
        LogHandlerProxy.install(platform, this.log);
        try {
            this.setCloner(SERIAL_CLONER);
        }
        catch (FjageException ex) {
            this.log.warning("Cloning disabled");
        }
        platform.addContainer(this);
    }

    public Container(Platform platform, String name) {
        this.name = name;
        this.platform = platform;
        LogHandlerProxy.install(platform, this.log);
        try {
            this.setCloner(SERIAL_CLONER);
        }
        catch (FjageException ex) {
            this.log.warning("Cloning disabled");
        }
        platform.addContainer(this);
    }

    public Platform getPlatform() {
        return this.platform;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setCloner(String name) {
        block4: {
            try {
                if (name.equals(SERIAL_CLONER)) {
                    this.cloner = null;
                    this.doClone = Class.forName(SERIAL_CLONER).getDeclaredMethod("clone", Serializable.class);
                    break block4;
                }
                if (name.equals(FAST_CLONER)) {
                    Class<?> cls = Class.forName(FAST_CLONER);
                    this.cloner = cls.newInstance();
                    this.doClone = cls.getMethod("deepClone", Object.class);
                    break block4;
                }
                this.cloner = null;
                this.doClone = null;
                throw new FjageException("Unknown cloner name");
            }
            catch (Exception ex) {
                this.log.warning("Cloner creation failed: " + ex.toString());
                this.cloner = null;
                this.doClone = null;
                throw new FjageException("Cloner creation failed");
            }
        }
    }

    public <T extends Serializable> T clone(T obj) {
        if (this.doClone == null) {
            throw new FjageException("Cloner unavailable");
        }
        try {
            return (T)((Serializable)this.doClone.invoke(this.cloner, obj));
        }
        catch (Exception ex) {
            this.log.warning("Cloning failed: " + ex.toString());
            throw new FjageException("Cloning failed");
        }
    }

    public void setAutoClone(boolean b) {
        this.autoclone = b;
    }

    public boolean getAutoClone() {
        return this.autoclone;
    }

    public AgentID add(String name, Agent agent) {
        if (name == null || name.length() == 0) {
            this.log.warning("Undefined agent name");
            return null;
        }
        AgentID aid = new AgentID(name);
        if (this.isDuplicate(aid)) {
            this.log.warning("Duplicate agent name: " + aid);
            return null;
        }
        agent.bind(aid, this);
        if (this.initing) {
            this.agentsToAdd.put(aid, agent);
        } else {
            this.agents.put(aid, agent);
        }
        AgentLocalRandom.bind(agent);
        if (this.running) {
            Thread t = new Thread(agent);
            t.setName(name);
            t.setDaemon(false);
            AgentLocalRandom.bind(agent, t);
            t.start();
        }
        return aid;
    }

    public AgentID add(Agent agent) {
        return this.add(agent.getClass().getName() + "@" + agent.hashCode(), agent);
    }

    public boolean containsAgent(AgentID aid) {
        return this.agents.containsKey(aid);
    }

    public boolean canLocateAgent(AgentID aid) {
        return this.isDuplicate(aid);
    }

    public Agent getAgent(AgentID aid) {
        return this.agents.get(aid);
    }

    public AgentID[] getAgents() {
        return this.agents.keySet().toArray(new AgentID[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean kill(AgentID aid) {
        this.log.fine("Agent " + aid + " killed");
        Container container = this;
        synchronized (container) {
            Agent agent = this.agents.get(aid);
            if (agent == null) {
                return false;
            }
            agent.stop();
            this.agents.remove(aid);
            this.idle.remove(aid);
            this.unsubscribe(aid);
            this.deregister(aid);
            this.notify();
        }
        return true;
    }

    public boolean kill(String name) {
        return this.kill(new AgentID(name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addListener(MessageListener listener) {
        Set<MessageListener> set = this.listeners;
        synchronized (set) {
            return this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeListener(MessageListener listener) {
        Set<MessageListener> set = this.listeners;
        synchronized (set) {
            return this.listeners.remove(listener);
        }
    }

    public boolean send(Message m) {
        return this.send(m, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean send(Message m, boolean relay) {
        if (!this.running) {
            return false;
        }
        if (relay) {
            this.log.warning("Container does not support relaying");
        }
        if (m.getSentAt() == null) {
            m.setSentAt(this.platform.currentTimeMillis());
        }
        Set<MessageListener> set = this.listeners;
        synchronized (set) {
            for (MessageListener listener : this.listeners) {
                if (!listener.onReceive(m)) continue;
                return true;
            }
        }
        AgentID aid = m.getRecipient();
        if (aid == null) {
            return false;
        }
        if (aid.isTopic()) {
            Container container = this;
            synchronized (container) {
                Set<Agent> subscribers = this.topics.get(aid);
                if (subscribers != null) {
                    for (Agent a : subscribers) {
                        a.deliver(m);
                    }
                }
            }
        } else {
            Agent a = this.getAgent(aid);
            if (a == null) {
                return false;
            }
            a.deliver(m);
        }
        return true;
    }

    public synchronized boolean subscribe(AgentID aid, AgentID topic) {
        Agent agent;
        if (!topic.isTopic()) {
            topic = new AgentID(topic.getName() + "__ntf", true);
        }
        if ((agent = this.agents.get(aid)) == null) {
            this.log.warning("Unable to subscribe unknown agent " + aid + " to topic " + topic);
            return false;
        }
        Set<Agent> subscribers = this.topics.get(topic);
        if (subscribers == null) {
            subscribers = new HashSet<Agent>();
            this.topics.put(topic, subscribers);
        }
        subscribers.add(agent);
        return true;
    }

    public synchronized boolean unsubscribe(AgentID aid, AgentID topic) {
        Agent agent;
        if (!topic.isTopic()) {
            topic = new AgentID(topic.getName() + "__ntf", true);
        }
        if ((agent = this.agents.get(aid)) == null) {
            return false;
        }
        Set<Agent> subscribers = this.topics.get(topic);
        if (subscribers == null) {
            return false;
        }
        return subscribers.remove(agent);
    }

    public synchronized void unsubscribe(AgentID aid) {
        Agent agent = this.agents.get(aid);
        if (agent == null) {
            return;
        }
        for (AgentID topic : this.topics.keySet()) {
            Set<Agent> subscribers = this.topics.get(topic);
            subscribers.remove(agent);
        }
    }

    public synchronized boolean register(AgentID aid, String service) {
        Set<AgentID> providers = this.services.get(service);
        if (providers == null) {
            providers = new HashSet<AgentID>();
            this.services.put(service, providers);
        }
        providers.add(aid);
        return true;
    }

    public synchronized String[] getServices() {
        Set<String> svc = this.services.keySet();
        return svc.toArray(new String[0]);
    }

    public synchronized AgentID agentForService(String service) {
        Set<AgentID> providers = this.services.get(service);
        if (providers == null || providers.size() == 0) {
            return null;
        }
        return providers.iterator().next();
    }

    public synchronized AgentID[] agentsForService(String service) {
        Set<AgentID> providers = this.services.get(service);
        if (providers == null || providers.size() == 0) {
            return null;
        }
        return providers.toArray(new AgentID[0]);
    }

    public synchronized boolean deregister(AgentID aid, String service) {
        Set<AgentID> providers = this.services.get(service);
        if (providers == null) {
            return false;
        }
        return providers.remove(aid);
    }

    public synchronized void deregister(AgentID aid) {
        for (String service : this.services.keySet()) {
            Set<AgentID> providers = this.services.get(service);
            providers.remove(aid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void init() {
        if (!this.running) {
            Thread t;
            Agent a;
            TreeSet<AgentID> keys;
            this.log.info("Initializing agents...");
            this.initing = true;
            Map<AgentID, Agent> map = this.agents;
            synchronized (map) {
                keys = new TreeSet<AgentID>(this.agents.keySet());
                for (AgentID aid : keys) {
                    this.log.fine("Starting agent " + aid);
                    a = this.agents.get(aid);
                    t = new Thread(a);
                    t.setName(a.getName());
                    t.setDaemon(false);
                    AgentLocalRandom.bind(a, t);
                    t.start();
                }
            }
            this.log.fine("Waiting for agents...");
            do {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException ex) {
                    this.log.warning("Init interrupted!");
                    Thread.currentThread().interrupt();
                    this.initing = false;
                    return;
                }
                if (this.agentsToAdd.size() <= 0) continue;
                map = this.agents;
                synchronized (map) {
                    this.agents.putAll(this.agentsToAdd);
                    keys = new TreeSet<AgentID>(this.agentsToAdd.keySet());
                    for (AgentID aid : keys) {
                        this.log.fine("Starting agent " + aid);
                        a = this.agents.get(aid);
                        t = new Thread(a);
                        t.setName(a.getName());
                        t.setDaemon(false);
                        AgentLocalRandom.bind(a, t);
                        t.start();
                    }
                    this.agentsToAdd.clear();
                }
            } while (!this.isIdle());
            this.initing = false;
            this.log.info("Agents ready...");
        }
    }

    void start() {
        if (!this.running) {
            this.log.info("Starting container...");
            this.running = true;
            for (Agent a : this.agents.values()) {
                if (a.getState() == AgentState.INIT) {
                    throw new FjageException("Container start() called without init()");
                }
                a.wake();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        if (!this.running) {
            return;
        }
        while (true) {
            try {
                this.log.info("Initiating shutdown...");
                for (Agent a : this.agents.values()) {
                    a.stop();
                }
                this.log.fine("Waiting for agents to shutdown...");
                Container container = this;
                synchronized (container) {
                    while (!this.agents.isEmpty()) {
                        try {
                            this.wait(100L);
                        }
                        catch (InterruptedException ex) {
                            this.log.warning("Shutdown interrupted!");
                            Thread.currentThread().interrupt();
                            this.agents.clear();
                            this.idle.clear();
                            this.running = false;
                            return;
                        }
                    }
                }
                this.log.info("All agents have shutdown");
                this.agents.clear();
                this.idle.clear();
                this.running = false;
                return;
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                continue;
            }
            break;
        }
    }

    public boolean isRunning() {
        return this.running;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isIdle() {
        int nAgents = this.agents.size();
        Set<AgentID> set = this.idle;
        synchronized (set) {
            return nAgents == this.idle.size();
        }
    }

    public String getState() {
        if (!this.running) {
            return "Not running";
        }
        return "Running";
    }

    public String toString() {
        String s = this.getClass().getName() + "@" + this.name;
        s = s + "/" + this.platform;
        return s;
    }

    <T extends Serializable> T autoclone(T obj) {
        if (this.autoclone) {
            return this.clone(obj);
        }
        return obj;
    }

    protected boolean isDuplicate(AgentID aid) {
        if (aid == null) {
            return false;
        }
        return this.agents.containsKey(aid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reportIdle(AgentID aid) {
        Set<AgentID> set = this.idle;
        synchronized (set) {
            this.idle.add(aid);
        }
        if (this.running && this.isIdle()) {
            this.platform.idle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reportBusy(AgentID aid) {
        Set<AgentID> set = this.idle;
        synchronized (set) {
            this.idle.remove(aid);
        }
    }
}

