/*
 * Decompiled with CFR 0.152.
 */
package org.arl.fjage;

import java.util.Queue;
import java.util.TimerTask;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.arl.fjage.DiscreteEvent;
import org.arl.fjage.LogHandlerProxy;
import org.arl.fjage.Platform;

public final class DiscreteEventSimulator
extends Platform
implements Runnable {
    private volatile long time = 0L;
    private Queue<DiscreteEvent> events = new PriorityBlockingQueue<DiscreteEvent>();
    private Logger log = Logger.getLogger(this.getClass().getName());
    private Thread thread = null;
    private float speed = Float.NaN;

    public DiscreteEventSimulator() {
        LogHandlerProxy.install(this, this.log);
    }

    public DiscreteEventSimulator(float speed) {
        LogHandlerProxy.install(this, this.log);
        this.speed = speed;
    }

    @Override
    public long currentTimeMillis() {
        return this.time;
    }

    @Override
    public long nanoTime() {
        return this.time * 1000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delay(long millis) {
        if (millis <= 0L) {
            return;
        }
        final Object sync = new Object();
        long t = this.time + millis;
        long dt = millis;
        while (dt > 0L) {
            Object object = sync;
            synchronized (object) {
                this.addEvent(new DiscreteEvent(this.time, t, new TimerTask(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Object object = sync;
                        synchronized (object) {
                            sync.notify();
                        }
                    }
                }, true));
                try {
                    sync.wait();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
            dt = t - this.time;
        }
    }

    @Override
    public void schedule(TimerTask task, long millis) {
        if (millis <= 0L) {
            task.run();
        } else {
            this.addEvent(new DiscreteEvent(this.time, this.time + millis, task));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void idle() {
        this.log.fine("Container went idle");
        DiscreteEventSimulator discreteEventSimulator = this;
        synchronized (discreteEventSimulator) {
            this.notify();
        }
    }

    @Override
    public void start() {
        super.start();
        this.thread = new Thread(this);
        this.thread.setName(this.getClass().getSimpleName());
        this.thread.setDaemon(true);
        this.thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        super.shutdown();
        Object object = this.events;
        synchronized (object) {
            this.events.clear();
        }
        object = this;
        synchronized (object) {
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            DiscreteEvent e = this.events.peek();
            while (this.running) {
                while (e != null && e.time <= this.time) {
                    this.log.fine("Fire " + e);
                    Queue<DiscreteEvent> queue = this.events;
                    synchronized (queue) {
                        if (this.events.size() > 0) {
                            this.events.poll().task.run();
                        }
                    }
                    e = this.events.peek();
                }
                Thread.yield();
                DiscreteEventSimulator discreteEventSimulator = this;
                synchronized (discreteEventSimulator) {
                    while (this.running && !this.isIdle()) {
                        try {
                            this.log.fine("Waiting for agents");
                            this.wait();
                        }
                        catch (InterruptedException ex) {
                            Thread.currentThread().interrupt();
                        }
                    }
                }
                e = this.events.peek();
                if (e != null) {
                    long dt = e.time - this.time;
                    this.time = e.time;
                    if (dt <= 0L || Float.isNaN(this.speed)) continue;
                    long t = Math.round((float)dt / this.speed);
                    try {
                        Thread.sleep(t);
                    }
                    catch (InterruptedException ex) {
                        Thread.currentThread().interrupt();
                    }
                    continue;
                }
                this.log.fine("No more events pending, initiating shutdown");
                this.shutdown();
            }
        }
        catch (Exception ex) {
            this.log.log(Level.SEVERE, "Exception: ", ex);
        }
        this.log.info("Simulator shutdown");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addEvent(DiscreteEvent event) {
        this.log.fine("Adding " + event);
        this.events.add(event);
        if (this.thread != null && this.thread.getState() == Thread.State.WAITING) {
            DiscreteEventSimulator discreteEventSimulator = this;
            synchronized (discreteEventSimulator) {
                this.notify();
            }
        }
    }
}

