/*
 * Decompiled with CFR 0.152.
 */
package org.arl.fjage;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.arl.fjage.Agent;
import org.arl.fjage.Behavior;
import org.arl.fjage.FjageException;

public class FSMBehavior
extends Behavior {
    private static final State INIT = new State("#INIT#");
    private static final State FINAL = new State("#FINAL#");
    private static final State REENTER = new State("#REENTER#");
    private Map<Object, State> states = new HashMap<Object, State>();
    private State initial = FINAL;
    private State state = INIT;
    private State next = INIT;
    private State old = INIT;

    public FSMBehavior() {
    }

    public FSMBehavior(State ... states) {
        for (State state : states) {
            this.add(state);
        }
    }

    @Override
    public void action() {
        if (this.state == INIT) {
            this.state = this.next = this.initial;
        }
        if (this.old == this.state) {
            this.state.action();
        } else {
            if (this.state == REENTER) {
                this.state = this.next = this.old;
            }
            this.old.onExit();
            this.state.onEnter();
        }
        this.old = this.state;
        this.state = this.next;
        if (this.old != this.state) {
            this.restart();
        }
    }

    @Override
    public boolean done() {
        return this.state == FINAL;
    }

    @Override
    public void reset() {
        this.state = this.next = INIT;
    }

    @Override
    void setOwner(Agent agent) {
        super.setOwner(agent);
        for (State s : this.states.values()) {
            s.log = this.log;
        }
    }

    public void clear() {
        this.reset();
        this.states.clear();
        this.initial = FINAL;
    }

    public void add(State state) {
        if (this.states.containsKey(state.name)) {
            throw new FjageException("Duplicate state name: " + state.name);
        }
        this.states.put(state.getName(), state);
        state.fsm = this;
        state.log = this.log;
        if (this.initial == FINAL) {
            this.initial = state;
        }
    }

    public void setInitialState(Object name) {
        State state;
        State state2 = state = name instanceof State ? (State)name : this.states.get(name);
        if (state == null) {
            throw new FjageException("Unknown state: " + name);
        }
        this.initial = state;
    }

    public void setNextState(Object name) {
        State state;
        State state2 = state = name instanceof State ? (State)name : this.states.get(name);
        if (state == null) {
            throw new FjageException("Unknown state: " + name);
        }
        this.next = state;
        this.restart();
    }

    public void reenterState() {
        this.next = REENTER;
        this.restart();
    }

    public Object getCurrentState() {
        return this.state.getName();
    }

    public void terminate() {
        this.setNextState(FINAL);
    }

    public void trigger(Object event) {
        this.state.onEvent(event, null);
    }

    public void trigger(Object event, Object eventInfo) {
        this.state.onEvent(event, eventInfo);
    }

    public static class State {
        private Object name;
        private Runnable runnable;
        public FSMBehavior fsm = null;
        public Logger log = null;

        public State(Object name) {
            this.name = name;
        }

        public State(Object name, Runnable runnable) {
            this(name);
            this.runnable = runnable;
        }

        public void action() {
            if (this.runnable != null) {
                this.runnable.run();
            } else {
                this.block();
            }
        }

        public void onEnter() {
        }

        public void onExit() {
        }

        public void onEvent(Object event, Object eventInfo) {
        }

        public Object getName() {
            return this.name;
        }

        public String toString() {
            return this.name.toString();
        }

        public void setNextState(Object name) {
            if (this.fsm != null) {
                this.fsm.setNextState(name);
            }
        }

        public void terminate() {
            if (this.fsm != null) {
                this.fsm.terminate();
            }
        }

        public void block() {
            if (this.fsm != null) {
                this.fsm.block();
            }
        }

        public void block(long millis) {
            if (this.fsm != null) {
                this.fsm.block(millis);
            }
        }

        public void restart() {
            if (this.fsm != null) {
                this.fsm.restart();
            }
        }

        public boolean isBlocked() {
            if (this.fsm == null) {
                return false;
            }
            return this.fsm.isBlocked();
        }
    }
}

