/*
 * Decompiled with CFR 0.152.
 */
package org.arl.fjage;

import java.util.AbstractMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.arl.fjage.AgentID;
import org.arl.fjage.GenericValue;
import org.arl.fjage.Message;
import org.arl.fjage.Performative;

public class GenericMessage
extends Message
implements Map<Object, Object> {
    private static final long serialVersionUID = -1L;
    private Map<Object, GenericValue> map = new HashMap<Object, GenericValue>();

    public GenericMessage() {
    }

    public GenericMessage(Performative perf) {
        super(perf);
    }

    public GenericMessage(AgentID recipient) {
        super(recipient);
    }

    public GenericMessage(AgentID recipient, Performative perf) {
        super(recipient, perf);
    }

    public GenericMessage(Message inReplyTo) {
        super(inReplyTo);
    }

    public GenericMessage(Message inReplyTo, Performative perf) {
        super(inReplyTo, perf);
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(new GenericValue(value));
    }

    @Override
    public Set<Map.Entry<Object, Object>> entrySet() {
        HashSet<Map.Entry<Object, Object>> set = new HashSet<Map.Entry<Object, Object>>();
        for (Map.Entry<Object, GenericValue> entry : this.map.entrySet()) {
            Object k = entry.getKey();
            GenericValue v = entry.getValue();
            set.add(new AbstractMap.SimpleEntry<Object, GenericValue>(k, v));
        }
        return set;
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public Set<Object> keySet() {
        return this.map.keySet();
    }

    @Override
    public Object put(Object key, Object value) {
        if (key.equals("performative")) {
            this.setPerformative((Performative)((Object)value));
            return value;
        }
        if (key.equals("recipient")) {
            this.setRecipient((AgentID)value);
            return value;
        }
        if (key.equals("sender")) {
            return this.getSender();
        }
        if (key.equals("messageID")) {
            return this.getMessageID();
        }
        if (key.equals("inReplyTo")) {
            return this.getInReplyTo();
        }
        if (value instanceof GenericValue) {
            return this.map.put(key, (GenericValue)value);
        }
        return this.map.put(key, new GenericValue(value));
    }

    @Override
    public Object get(Object key) {
        if (key.equals("performative")) {
            return this.getPerformative();
        }
        if (key.equals("recipient")) {
            return this.getRecipient();
        }
        if (key.equals("sender")) {
            return this.getSender();
        }
        if (key.equals("messageID")) {
            return this.getMessageID();
        }
        if (key.equals("inReplyTo")) {
            return this.getInReplyTo();
        }
        GenericValue v = this.map.get(key);
        if (v == null) {
            return null;
        }
        return v.getValue();
    }

    @Override
    public void putAll(Map<? extends Object, ? extends Object> map) {
        for (Map.Entry<? extends Object, ? extends Object> entry : map.entrySet()) {
            Object k = entry.getKey();
            Object v = entry.getValue();
            if (v instanceof GenericValue) {
                this.map.put(k, (GenericValue)v);
                continue;
            }
            this.map.put(k, new GenericValue(v));
        }
    }

    @Override
    public Object remove(Object key) {
        return this.map.remove(key);
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public Collection<Object> values() {
        return Collections.unmodifiableCollection(this.map.values());
    }

    public String get(Object key, String defVal) {
        Object obj = this.get(key);
        if (obj == null) {
            return defVal;
        }
        return obj.toString();
    }

    public int get(Object key, int defVal) {
        Object obj = this.get(key);
        if (obj == null) {
            return defVal;
        }
        return ((Number)obj).intValue();
    }

    public long get(Object key, long defVal) {
        Object obj = this.get(key);
        if (obj == null) {
            return defVal;
        }
        return ((Number)obj).longValue();
    }

    public double get(Object key, double defVal) {
        Object obj = this.get(key);
        if (obj == null) {
            return defVal;
        }
        return ((Number)obj).doubleValue();
    }
}

