/*
 * Decompiled with CFR 0.152.
 */
package org.arl.fjage;

import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class LogFormatter
extends Formatter {
    private static String[] ignorePkgList = new String[]{"org.codehaus.groovy.", "java.", "groovy.", "sun."};

    @Override
    public String format(LogRecord record) {
        StringBuffer s = new StringBuffer();
        s.append(record.getMillis());
        s.append('|');
        s.append(record.getLevel());
        s.append('|');
        s.append(record.getLoggerName());
        s.append('@');
        s.append(record.getThreadID());
        s.append(':');
        s.append(record.getSourceMethodName());
        s.append('|');
        s.append(LogFormatter.indent(record.getMessage()));
        s.append('\n');
        Throwable t = record.getThrown();
        if (t != null) {
            this.printStackTrace(t, s);
        }
        return s.toString();
    }

    private void printStackTrace(Throwable t, StringBuffer s) {
        s.append('\n');
        String msg = t.toString();
        if (msg == null) {
            msg = t.getClass().getName();
        }
        s.append(msg);
        s.append("\nStack trace:");
        boolean ignoring = false;
        for (StackTraceElement st : t.getStackTrace()) {
            boolean disp = true;
            for (String p : ignorePkgList) {
                if (!st.getClassName().startsWith(p)) continue;
                disp = false;
            }
            if (disp) {
                s.append("\n   ");
                s.append(st.toString());
                ignoring = false;
                continue;
            }
            if (!ignoring) {
                s.append(" ...");
            }
            ignoring = true;
        }
        s.append("\n\n");
    }

    public static void install(Logger log) {
        Handler[] h;
        if (log == null) {
            log = Logger.getLogger("");
        }
        LogFormatter f = new LogFormatter();
        for (Handler h1 : h = log.getHandlers()) {
            h1.setFormatter(f);
        }
    }

    private static String indent(String s) {
        if (s == null || s.indexOf(10) < 0) {
            return s;
        }
        return s.replaceAll("\n", "\n\t");
    }
}

