/*
 * Decompiled with CFR 0.152.
 */
package org.arl.fjage;

import java.util.logging.Handler;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.arl.fjage.TimestampProvider;

public class LogHandlerProxy
extends Handler {
    private Handler delegate;
    private TimestampProvider timesrc;

    public LogHandlerProxy(Handler delegate, TimestampProvider timesrc) {
        this.delegate = delegate;
        this.timesrc = timesrc;
    }

    public void setTimestampProvider(TimestampProvider timesrc) {
        this.timesrc = timesrc;
    }

    @Override
    public void publish(LogRecord rec) {
        if (this.timesrc != null) {
            rec.setMillis(this.timesrc.currentTimeMillis());
        }
        this.delegate.publish(rec);
    }

    @Override
    public void close() {
        this.delegate.close();
    }

    @Override
    public void flush() {
        this.delegate.flush();
    }

    public static void install(TimestampProvider timesrc, Logger log) {
        Handler[] h;
        if (log == null) {
            log = Logger.getLogger("");
        }
        if ((h = log.getHandlers()).length == 0) {
            Logger log1 = log;
            while (h.length == 0) {
                if ((log1 = log1.getParent()) == null) {
                    return;
                }
                h = log1.getHandlers();
            }
            for (Handler h1 : h) {
                LogHandlerProxy h2 = new LogHandlerProxy(h1, timesrc);
                log.setUseParentHandlers(false);
                log.addHandler(h2);
            }
        } else {
            for (Handler h1 : h) {
                if (h1 instanceof LogHandlerProxy) {
                    ((LogHandlerProxy)h1).setTimestampProvider(timesrc);
                    continue;
                }
                LogHandlerProxy h2 = new LogHandlerProxy(h1, timesrc);
                log.removeHandler(h1);
                log.addHandler(h2);
            }
        }
    }
}

