/*
 * Decompiled with CFR 0.152.
 */
package org.arl.fjage;

import java.io.Serializable;
import java.util.UUID;
import org.arl.fjage.AgentID;
import org.arl.fjage.Performative;

public class Message
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected String msgID = UUID.randomUUID().toString();
    protected Performative perf;
    protected AgentID recipient;
    protected AgentID sender = null;
    protected String inReplyTo = null;
    protected Long sentAt = null;

    public Message() {
        this.perf = Performative.INFORM;
        this.recipient = null;
    }

    public Message(Performative perf) {
        this.perf = perf;
        this.recipient = null;
    }

    public Message(AgentID recipient) {
        this.perf = null;
        this.recipient = recipient;
    }

    public Message(AgentID recipient, Performative perf) {
        this.perf = perf;
        this.recipient = recipient;
    }

    public Message(Message inReplyTo) {
        this.perf = null;
        this.recipient = inReplyTo.sender;
        this.inReplyTo = inReplyTo.msgID;
    }

    public Message(Message inReplyTo, Performative perf) {
        this.perf = perf;
        this.recipient = inReplyTo.sender;
        this.inReplyTo = inReplyTo.msgID;
    }

    public void setPerformative(Performative perf) {
        this.perf = perf;
    }

    public Performative getPerformative() {
        return this.perf;
    }

    public void setRecipient(AgentID aid) {
        this.recipient = aid;
    }

    public AgentID getRecipient() {
        return this.recipient;
    }

    public void setSender(AgentID aid) {
        this.sender = aid;
    }

    public AgentID getSender() {
        return this.sender;
    }

    public void setMessageID(String id) {
        this.msgID = id;
    }

    public String getMessageID() {
        return this.msgID;
    }

    public void setInReplyTo(String id) {
        this.inReplyTo = id;
    }

    public String getInReplyTo() {
        return this.inReplyTo;
    }

    public void setSentAt(long ms) {
        this.sentAt = ms;
    }

    public Long getSentAt() {
        return this.sentAt;
    }

    public String toString() {
        String p = this.perf != null ? this.perf.toString() : "MESSAGE";
        Class<?> cls = this.getClass();
        if (cls.equals(Message.class)) {
            return p;
        }
        return p + ": " + cls.getSimpleName();
    }
}

