/*
 * Decompiled with CFR 0.152.
 */
package org.arl.fjage;

import java.util.function.Consumer;
import org.arl.fjage.Behavior;
import org.arl.fjage.Message;
import org.arl.fjage.MessageFilter;

public class MessageBehavior
extends Behavior {
    private MessageFilter filter;

    public MessageBehavior() {
        this.filter = null;
    }

    public MessageBehavior(Class<?> cls) {
        this.filter = m -> cls.isInstance(m);
    }

    public MessageBehavior(MessageFilter filter) {
        this.filter = filter;
    }

    public MessageBehavior(Consumer<Message> consumer) {
        this();
        if (consumer != null) {
            this.action = param -> consumer.accept((Message)param);
        }
    }

    public MessageBehavior(Class<?> cls, Consumer<Message> consumer) {
        this(cls);
        if (consumer != null) {
            this.action = param -> consumer.accept((Message)param);
        }
    }

    public MessageBehavior(MessageFilter filter, Consumer<Message> consumer) {
        this(filter);
        if (consumer != null) {
            this.action = param -> consumer.accept((Message)param);
        }
    }

    boolean hasFilter() {
        return this.filter != null;
    }

    public boolean accepts(Message msg) {
        if (this.filter == null) {
            return true;
        }
        return this.filter.matches(msg);
    }

    public void onReceive(Message msg) {
        if (this.action != null) {
            this.action.call(msg);
        }
    }

    @Override
    public final void action() {
        Message msg = this.filter == null ? this.agent.receive() : this.agent.receive(this.filter, 0L);
        if (msg == null) {
            this.block();
        } else {
            this.onReceive(msg);
        }
    }

    @Override
    public final boolean done() {
        return false;
    }

    @Override
    public int getPriority() {
        if (this.filter != null) {
            return -100;
        }
        return 0;
    }

    public static MessageBehavior create(final Consumer<Message> consumer) {
        return new MessageBehavior(){

            @Override
            public void onReceive(Message message) {
                consumer.accept(message);
            }
        };
    }

    public static MessageBehavior create(Class<? extends Message> messageClass, final Consumer<Message> consumer) {
        return new MessageBehavior((Class)messageClass){

            @Override
            public void onReceive(Message message) {
                consumer.accept(message);
            }
        };
    }

    public static MessageBehavior create(MessageFilter messageFilter, final Consumer<Message> consumer) {
        return new MessageBehavior(messageFilter){

            @Override
            public void onReceive(Message message) {
                consumer.accept(message);
            }
        };
    }
}

