/*
 * Decompiled with CFR 0.152.
 */
package org.arl.fjage;

import java.util.Iterator;
import java.util.LinkedList;
import org.arl.fjage.Message;
import org.arl.fjage.MessageFilter;

public class MessageQueue {
    private LinkedList<Message> queue = new LinkedList();
    private LinkedList<Message> quarantine = new LinkedList();
    private int maxQueueLen;

    public MessageQueue() {
        this.maxQueueLen = 0;
    }

    public MessageQueue(int maxlen) {
        this.maxQueueLen = maxlen;
    }

    public synchronized void setSize(int size) {
        this.maxQueueLen = size;
        while (this.maxQueueLen > 0 && this.queue.size() >= this.maxQueueLen) {
            this.queue.remove();
        }
    }

    public synchronized void add(Message m) {
        this.quarantine.offer(m);
        while (this.maxQueueLen > 0 && this.quarantine.size() >= this.maxQueueLen) {
            this.quarantine.remove();
        }
    }

    public synchronized void commit(Iterable<MessageFilter> exclusions) {
        Iterator it = this.quarantine.iterator();
        while (it.hasNext()) {
            Message m = (Message)it.next();
            boolean exclude = false;
            for (MessageFilter mf : exclusions) {
                if (mf != null && !mf.matches(m)) continue;
                exclude = true;
                break;
            }
            if (exclude) continue;
            it.remove();
            this.queue.offer(m);
        }
        while (this.maxQueueLen > 0 && this.queue.size() >= this.maxQueueLen) {
            this.queue.remove();
        }
    }

    public synchronized Message get() {
        return this.queue.poll();
    }

    public synchronized Message get(MessageFilter filter) {
        if (filter == null) {
            return this.queue.poll();
        }
        Iterator it = this.queue.iterator();
        while (it.hasNext()) {
            Message m = (Message)it.next();
            if (!filter.matches(m)) continue;
            it.remove();
            return m;
        }
        return null;
    }

    public synchronized void clear() {
        this.queue.clear();
    }

    public int length() {
        return this.queue.size();
    }
}

