/*
 * Decompiled with CFR 0.152.
 */
package org.arl.fjage;

import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.JarURLConnection;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.TimerTask;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.arl.fjage.Container;
import org.arl.fjage.FjageException;
import org.arl.fjage.TimestampProvider;

public abstract class Platform
implements TimestampProvider {
    protected List<Container> containers = new ArrayList<Container>();
    protected boolean running = false;
    private String hostname = null;
    private int port = 1099;
    private NetworkInterface nif = null;

    @Override
    public abstract long currentTimeMillis();

    @Override
    public abstract long nanoTime();

    public abstract void schedule(TimerTask var1, long var2);

    public abstract void idle();

    public abstract void delay(long var1);

    public void addContainer(Container container) {
        if (this.running) {
            throw new FjageException("Cannot add container to running platform");
        }
        this.containers.add(container);
    }

    public Container[] getContainers() {
        return this.containers.toArray(new Container[0]);
    }

    public void start() {
        for (Container c : this.containers) {
            c.init();
        }
        for (Container c : this.containers) {
            c.start();
        }
        this.running = true;
    }

    public void shutdown() {
        Thread t = new Thread(() -> {
            for (Container c : this.containers) {
                if (c == null) continue;
                c.shutdown();
            }
            this.running = false;
        });
        t.start();
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public String getHostname() {
        if (this.hostname != null) {
            return this.hostname;
        }
        try {
            InetAddress addr;
            if (this.nif == null) {
                addr = InetAddress.getLocalHost();
            } else {
                Enumeration<InetAddress> alist = this.nif.getInetAddresses();
                addr = alist.nextElement();
                while (addr instanceof Inet6Address) {
                    addr = alist.nextElement();
                }
            }
            if (addr == null) {
                return "localhost";
            }
            return addr.getHostAddress();
        }
        catch (UnknownHostException ex) {
            return "localhost";
        }
    }

    public NetworkInterface getNetworkInterface() {
        return this.nif;
    }

    public void setNetworkInterface(String name) throws SocketException {
        this.nif = NetworkInterface.getByName(name);
    }

    public void setNetworkInterface(NetworkInterface nif) {
        this.nif = nif;
    }

    public boolean isRunning() {
        for (Container c : this.containers) {
            if (c == null || !c.isRunning()) continue;
            return true;
        }
        return false;
    }

    public boolean isIdle() {
        for (Container c : this.containers) {
            if (c == null || c.isIdle()) continue;
            return false;
        }
        return true;
    }

    public static String getBuildVersion() {
        try {
            Class<Platform> cls = Platform.class;
            URL res = cls.getResource(cls.getSimpleName() + ".class");
            JarURLConnection conn = (JarURLConnection)res.openConnection();
            Manifest mf = conn.getManifest();
            Attributes a = mf.getMainAttributes();
            return "fjage-" + a.getValue("Build-Version") + "/" + a.getValue("Build-Timestamp");
        }
        catch (Exception ex) {
            return "(unknown)";
        }
    }
}

