/*
 * Decompiled with CFR 0.152.
 */
package org.arl.fjage;

import org.arl.fjage.AgentLocalRandom;
import org.arl.fjage.Behavior;

public class PoissonBehavior
extends Behavior {
    private int ticks;
    private long expDelay;
    private long wakeupTime;
    private boolean quit;

    public PoissonBehavior(long millis) {
        this.expDelay = millis;
        this.ticks = 0;
        this.quit = false;
    }

    public PoissonBehavior(long millis, Runnable runnable) {
        this(millis);
        if (runnable != null) {
            this.action = param -> runnable.run();
        }
    }

    public final void stop() {
        this.quit = true;
    }

    public final int getTickCount() {
        return this.ticks;
    }

    public void onTick() {
        super.action();
    }

    @Override
    public void onStart() {
        long delayToNext = Math.round(AgentLocalRandom.current().nextExp() * (double)this.expDelay);
        this.wakeupTime = this.agent.currentTimeMillis() + delayToNext;
        this.block(delayToNext);
    }

    @Override
    public final void action() {
        if (this.quit) {
            return;
        }
        long dt = this.wakeupTime - this.agent.currentTimeMillis();
        if (dt > 0L) {
            this.block(dt);
        } else {
            ++this.ticks;
            this.onTick();
            long delayToNext = Math.round(AgentLocalRandom.current().nextExp() * (double)this.expDelay);
            this.wakeupTime = this.agent.currentTimeMillis() + delayToNext;
        }
    }

    @Override
    public boolean done() {
        return this.quit;
    }

    @Override
    public void reset() {
        super.reset();
        this.ticks = 0;
        this.quit = false;
    }

    @Override
    public int getPriority() {
        return Integer.MIN_VALUE;
    }

    public static PoissonBehavior create(long millis, final Runnable runnable) {
        return new PoissonBehavior(millis){

            @Override
            public void onTick() {
                runnable.run();
            }
        };
    }
}

