/*
 * Decompiled with CFR 0.152.
 */
package org.arl.fjage;

import org.arl.fjage.Agent;
import org.arl.fjage.OneShotBehavior;

public class TestBehavior
extends OneShotBehavior {
    private AssertionError error = null;
    private boolean completed = false;

    public TestBehavior() {
    }

    public TestBehavior(Runnable runnable) {
        this();
        if (runnable != null) {
            this.action = param -> runnable.run();
        }
    }

    @Override
    public final void action() {
        try {
            this.test();
        }
        catch (AssertionError ex) {
            this.error = ex;
        }
        this.completed = true;
    }

    @Override
    public void reset() {
        super.reset();
        this.completed = false;
        this.error = null;
    }

    public boolean hasCompleted() {
        return this.completed;
    }

    public void checkAssertions() {
        if (this.error != null) {
            throw this.error;
        }
    }

    public void runOn(Agent agent) {
        this.reset();
        agent.add(this);
        while (!this.hasCompleted()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
        }
        this.checkAssertions();
    }

    public void test() {
        super.action();
    }
}

