/*
 * Decompiled with CFR 0.152.
 */
package org.arl.fjage;

import org.arl.fjage.Behavior;

public class TickerBehavior
extends Behavior {
    private int ticks;
    private long period;
    private long wakeupTime;
    private boolean quit;

    public TickerBehavior(long millis) {
        this.period = millis;
        this.ticks = 0;
        this.quit = false;
    }

    public TickerBehavior(long millis, Runnable runnable) {
        this(millis);
        if (runnable != null) {
            this.action = param -> runnable.run();
        }
    }

    public final void stop() {
        this.quit = true;
    }

    public final int getTickCount() {
        return this.ticks;
    }

    public void onTick() {
        super.action();
    }

    @Override
    public void onStart() {
        this.wakeupTime = this.agent.currentTimeMillis() + this.period;
        this.block(this.period);
    }

    @Override
    public final void action() {
        if (this.quit) {
            return;
        }
        long t = this.agent.currentTimeMillis();
        long dt = this.wakeupTime - t;
        if (dt > 0L) {
            this.block(dt);
        } else {
            ++this.ticks;
            this.onTick();
            this.wakeupTime += this.period;
            if (this.wakeupTime < t) {
                this.wakeupTime = t + this.period;
            }
        }
    }

    @Override
    public final boolean done() {
        return this.quit;
    }

    @Override
    public void reset() {
        super.reset();
        this.ticks = 0;
        this.quit = false;
    }

    @Override
    public int getPriority() {
        return Integer.MIN_VALUE;
    }

    public static TickerBehavior create(long millis, final Runnable runnable) {
        return new TickerBehavior(millis){

            @Override
            public void onTick() {
                runnable.run();
            }
        };
    }
}

