/*
 * Decompiled with CFR 0.152.
 */
package org.arl.fjage;

import org.arl.fjage.Behavior;

public class WakerBehavior
extends Behavior {
    private long timeout;
    private long wakeupTime;
    private boolean quit;

    public WakerBehavior(long millis) {
        this.timeout = millis;
        this.quit = false;
    }

    public WakerBehavior(long millis, Runnable runnable) {
        this(millis);
        if (runnable != null) {
            this.action = param -> runnable.run();
        }
    }

    public final long getWakeupTime() {
        return this.wakeupTime;
    }

    public final void stop() {
        this.quit = true;
    }

    public void onWake() {
        super.action();
    }

    @Override
    public final void onStart() {
        this.wakeupTime = this.agent.currentTimeMillis() + this.timeout;
        this.block(this.timeout);
    }

    @Override
    public final void action() {
        if (this.quit) {
            return;
        }
        long dt = this.wakeupTime - this.agent.currentTimeMillis();
        if (dt > 0L) {
            this.block(dt);
        } else {
            this.onWake();
            this.quit = true;
        }
    }

    @Override
    public final boolean done() {
        return this.quit;
    }

    @Override
    public void reset() {
        super.reset();
        this.quit = false;
    }

    @Override
    public int getPriority() {
        return Integer.MIN_VALUE;
    }

    public static WakerBehavior create(long millis, final Runnable runnable) {
        return new WakerBehavior(millis){

            @Override
            public void onWake() {
                runnable.run();
            }
        };
    }
}

