/*
 * Decompiled with CFR 0.152.
 */
package org.arl.fjage.connectors;

import java.io.ByteArrayOutputStream;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;

public class BlockingByteQueue {
    protected static final int BLOCK_SIZE = 16384;
    protected BlockingQueue<byte[]> queue = new LinkedBlockingQueue<byte[]>();
    protected byte[] wbuf = new byte[16384];
    protected byte[] rbuf = this.wbuf;
    protected int bytes = 0;
    protected int wlen = 0;
    protected int rlen = 0;
    protected int rpos = 0;

    public synchronized void clear() {
        this.queue.clear();
        this.rbuf = this.wbuf;
        this.wlen = 0;
        this.rlen = 0;
        this.rpos = 0;
        this.bytes = 0;
        this.notify();
    }

    public synchronized void write(int c) {
        if (this.wlen == 16384) {
            if (this.bytes > 0) {
                if (this.rbuf != this.wbuf) {
                    this.queue.add(this.wbuf);
                }
                this.wbuf = new byte[16384];
            }
            this.wlen = 0;
        }
        this.wbuf[this.wlen++] = (byte)c;
        if (this.rbuf == this.wbuf) {
            this.rlen = this.wlen;
        }
        ++this.bytes;
        this.notify();
    }

    public synchronized void write(byte[] buf) {
        this.bytes += buf.length;
        if (this.wlen == 0 && buf.length > 16384) {
            this.queue.add(buf);
            this.notify();
            return;
        }
        if (this.wlen + buf.length < 16384) {
            System.arraycopy(buf, 0, this.wbuf, this.wlen, buf.length);
            this.wlen += buf.length;
            if (this.rbuf == this.wbuf) {
                this.rlen = this.wlen;
            }
            this.notify();
            return;
        }
        int len1 = 16384 - this.wlen;
        System.arraycopy(buf, 0, this.wbuf, this.wlen, len1);
        if (this.rbuf == this.wbuf) {
            this.rlen = 16384;
        } else {
            this.queue.add(this.wbuf);
        }
        int len2 = buf.length - len1;
        if (len2 > 16384) {
            this.wbuf = new byte[len2];
            System.arraycopy(buf, len1, this.wbuf, 0, len2);
            this.queue.add(this.wbuf);
            this.wbuf = new byte[16384];
            this.wlen = 0;
            this.notify();
            return;
        }
        this.wbuf = new byte[16384];
        System.arraycopy(buf, len1, this.wbuf, 0, len2);
        this.wlen = len2;
        this.notify();
    }

    public synchronized int read() {
        int c;
        try {
            if (this.bytes == 0) {
                this.wait();
            }
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
        if (this.bytes == 0) {
            return -1;
        }
        if (this.rpos >= this.rlen) {
            this.rbuf = (byte[])this.queue.poll();
            if (this.rbuf != null) {
                this.rlen = this.rbuf.length;
            } else {
                this.rbuf = this.wbuf;
                this.rlen = this.wlen;
            }
            this.rpos = 0;
        }
        if ((c = this.rbuf[this.rpos++]) < 0) {
            c += 256;
        }
        --this.bytes;
        return c;
    }

    public synchronized int read(byte[] buf) {
        for (int i = 0; i < buf.length; ++i) {
            if (i > 0 && this.bytes == 0) {
                return i;
            }
            int c = this.read();
            if (c < 0) {
                return i;
            }
            buf[i] = (byte)c;
        }
        return buf.length;
    }

    public synchronized byte[] readAvailable() {
        try {
            if (this.bytes == 0) {
                this.wait();
            }
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
        if (this.bytes == 0) {
            return null;
        }
        byte[] buf = new byte[this.bytes];
        this.read(buf);
        return buf;
    }

    public synchronized byte[] readDelimited(byte delimiter) {
        int c = -1;
        int d = delimiter;
        if (d < 0) {
            d += 256;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream(this.bytes);
        while (c != d) {
            c = this.read();
            if (c < 0) {
                if (baos.size() != 0) break;
                return null;
            }
            baos.write(c);
        }
        return baos.toByteArray();
    }

    public synchronized int available() {
        return this.bytes;
    }
}

