/*
 * Decompiled with CFR 0.152.
 */
package org.arl.fjage.connectors;

import java.io.IOException;
import java.io.InputStream;
import org.arl.fjage.connectors.BlockingByteQueue;

public class PseudoInputStream
extends InputStream {
    protected BlockingByteQueue q = new BlockingByteQueue();

    public void clear() {
        if (this.q != null) {
            this.q.clear();
        }
    }

    public void write(int c) throws IOException {
        if (this.q == null) {
            throw new IOException("Stream is closed");
        }
        this.q.write(c);
    }

    public void write(byte[] buf) throws IOException {
        if (this.q == null) {
            throw new IOException("Stream is closed");
        }
        this.q.write(buf);
    }

    @Override
    public int read() {
        if (this.q == null) {
            return -1;
        }
        return this.q.read();
    }

    @Override
    public int read(byte[] buf, int ofs, int len) {
        if (this.q == null) {
            return -1;
        }
        if (ofs == 0 && buf.length == len) {
            return this.q.read(buf);
        }
        byte[] tmp = new byte[len];
        int n = this.q.read(tmp);
        System.arraycopy(tmp, 0, buf, ofs, n);
        return n;
    }

    @Override
    public int read(byte[] buf) {
        if (this.q == null) {
            return -1;
        }
        return this.q.read(buf);
    }

    @Override
    public int available() {
        if (this.q == null) {
            return -1;
        }
        return this.q.available();
    }

    @Override
    public void close() {
        if (this.q == null) {
            return;
        }
        this.q.clear();
        this.q = null;
    }
}

