/*
 * Decompiled with CFR 0.152.
 */
package org.arl.fjage.connectors;

import java.io.IOException;
import java.io.OutputStream;
import org.arl.fjage.connectors.BlockingByteQueue;

public class PseudoOutputStream
extends OutputStream {
    protected BlockingByteQueue q = new BlockingByteQueue();

    public void clear() {
        if (this.q != null) {
            this.q.clear();
        }
    }

    @Override
    public void write(int c) throws IOException {
        if (this.q == null) {
            throw new IOException("Stream is closed");
        }
        this.q.write(c);
    }

    @Override
    public void write(byte[] buf) throws IOException {
        if (this.q == null) {
            throw new IOException("Stream is closed");
        }
        this.q.write(buf);
    }

    @Override
    public void write(byte[] buf, int ofs, int len) throws IOException {
        if (this.q == null) {
            throw new IOException("Stream is closed");
        }
        if (ofs == 0 && buf.length == len) {
            this.q.write(buf);
        } else {
            byte[] tmp = new byte[len];
            System.arraycopy(buf, ofs, tmp, 0, len);
            this.q.write(tmp);
        }
    }

    public int read() {
        if (this.q == null) {
            return -1;
        }
        return this.q.read();
    }

    public int read(byte[] buf) {
        if (this.q == null) {
            return -1;
        }
        return this.q.read(buf);
    }

    public byte[] readAvailable() {
        if (this.q == null) {
            return null;
        }
        return this.q.readAvailable();
    }

    public String readLine() {
        if (this.q == null) {
            return null;
        }
        byte[] buf = this.q.readDelimited((byte)10);
        if (buf == null) {
            return null;
        }
        return new String(buf);
    }

    public int available() {
        if (this.q == null) {
            return -1;
        }
        return this.q.available();
    }

    @Override
    public void close() {
        if (this.q == null) {
            return;
        }
        this.q.clear();
        this.q = null;
    }
}

