/*
 * Decompiled with CFR 0.152.
 */
package org.arl.fjage.connectors;

import com.fazecast.jSerialComm.SerialPort;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.arl.fjage.connectors.ConnectionListener;
import org.arl.fjage.connectors.Connector;

public class SerialPortConnector
implements Connector {
    protected SerialPort com;

    public SerialPortConnector(String devname, int baud, String settings) throws IOException {
        if (settings != null && settings != "N81") {
            throw new IOException("Bad serial port settings");
        }
        this.com = SerialPort.getCommPort((String)devname);
        this.com.setComPortParameters(baud, 8, 1, 0);
        this.com.openPort();
        this.com.setComPortTimeouts(1, 0, 0);
    }

    public SerialPort getSerialPort() {
        return this.com;
    }

    @Override
    public String getName() {
        if (this.com == null) {
            return "serial://[closed]";
        }
        return "serial://" + this.com.getDescriptivePortName();
    }

    @Override
    public InputStream getInputStream() {
        if (this.com == null) {
            return null;
        }
        return this.com.getInputStream();
    }

    @Override
    public OutputStream getOutputStream() {
        if (this.com == null) {
            return null;
        }
        return this.com.getOutputStream();
    }

    @Override
    public void setConnectionListener(ConnectionListener listener) {
        listener.connected(this);
    }

    @Override
    public void close() {
        if (this.com == null) {
            return;
        }
        this.com.closePort();
        this.com = null;
    }

    @Override
    public boolean isReliable() {
        return false;
    }

    @Override
    public boolean waitOutputCompletion(long timeout) {
        long t = System.currentTimeMillis() + timeout;
        while (this.com.bytesAwaitingWrite() > 0) {
            if (System.currentTimeMillis() > t) {
                return false;
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                return false;
            }
        }
        return true;
    }

    public String toString() {
        return this.getName();
    }
}

