/*
 * Decompiled with CFR 0.152.
 */
package org.arl.fjage.connectors;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import org.arl.fjage.connectors.ConnectionListener;
import org.arl.fjage.connectors.Connector;

public class TcpConnector
implements Connector {
    protected Socket sock;
    protected OutputStream out;

    public TcpConnector(String hostname, int port) throws IOException {
        this.sock = new Socket(hostname, port);
        this.sock.setTcpNoDelay(true);
        this.out = new BufferedOutputStream(this.sock.getOutputStream());
    }

    public TcpConnector(Socket sock) throws IOException {
        this.sock = sock;
        this.out = new BufferedOutputStream(sock.getOutputStream());
    }

    @Override
    public String getName() {
        if (this.sock == null) {
            return "tcp://[closed]";
        }
        return "tcp://" + this.sock.getLocalAddress() + ":" + this.sock.getLocalPort() + "/" + this.sock.getInetAddress() + "." + this.sock.getPort();
    }

    @Override
    public InputStream getInputStream() {
        if (this.sock == null) {
            return null;
        }
        try {
            return this.sock.getInputStream();
        }
        catch (IOException ex) {
            return null;
        }
    }

    @Override
    public OutputStream getOutputStream() {
        if (this.sock == null) {
            return null;
        }
        return this.out;
    }

    @Override
    public void setConnectionListener(ConnectionListener listener) {
        if (this.sock != null) {
            listener.connected(this);
        }
    }

    @Override
    public void close() {
        if (this.sock == null) {
            return;
        }
        try {
            this.sock.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.sock = null;
    }

    @Override
    public boolean isReliable() {
        return true;
    }

    @Override
    public boolean waitOutputCompletion(long timeout) {
        try {
            this.out.flush();
            return true;
        }
        catch (IOException ex) {
            return false;
        }
    }

    public String toString() {
        return this.getName();
    }
}

