/*
 * Decompiled with CFR 0.152.
 */
package org.arl.fjage.connectors;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import org.arl.fjage.connectors.ConnectionListener;
import org.arl.fjage.connectors.Connector;
import org.arl.fjage.connectors.PseudoInputStream;
import org.arl.fjage.connectors.PseudoOutputStream;

public class TcpHubConnector
extends Thread
implements Connector {
    protected int port;
    protected boolean telnet;
    protected ServerSocket sock = null;
    protected OutputThread outThread = null;
    protected List<ClientThread> clientThreads = Collections.synchronizedList(new ArrayList());
    protected Logger log = Logger.getLogger(this.getClass().getName());
    protected PseudoInputStream pin = new PseudoInputStream();
    protected PseudoOutputStream pout = new PseudoOutputStream();
    protected ConnectionListener listener = null;

    public TcpHubConnector(int port, boolean telnet) {
        this.port = port;
        this.telnet = telnet;
        try {
            this.setName("tcp://" + InetAddress.getLocalHost().getHostAddress() + ":" + port);
        }
        catch (UnknownHostException ex) {
            this.setName("tcp://0.0.0.0:" + port);
        }
        this.setDaemon(true);
        this.start();
    }

    public TcpHubConnector(int port) {
        this(port, false);
    }

    public synchronized int getPort() {
        if (this.port == 0) {
            try {
                this.wait(100L);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                return -1;
            }
        }
        return this.port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        List<ClientThread> list = this.clientThreads;
        synchronized (list) {
            for (ClientThread t : this.clientThreads) {
                t.close();
            }
        }
        this.clientThreads.clear();
        if (this.sock == null) {
            return;
        }
        try {
            this.sock.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.sock = null;
        this.pin.close();
        this.pout.close();
        this.pin = null;
        this.pout = null;
    }

    @Override
    public boolean isReliable() {
        return true;
    }

    @Override
    public boolean waitOutputCompletion(long timeout) {
        long t = System.currentTimeMillis() + timeout;
        while (this.pout != null && this.pout.available() > 0) {
            if (System.currentTimeMillis() > t) {
                return false;
            }
            try {
                TcpHubConnector.sleep(10L);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.outThread = new OutputThread();
        this.outThread.start();
        try {
            TcpHubConnector tcpHubConnector = this;
            synchronized (tcpHubConnector) {
                this.sock = new ServerSocket(this.port);
                this.port = this.sock.getLocalPort();
                this.notify();
            }
            try {
                this.setName("tcp://" + InetAddress.getLocalHost().getHostAddress() + ":" + this.port);
            }
            catch (UnknownHostException ex) {
                this.setName("tcp://0.0.0.0:" + this.port);
            }
            this.log.info("Listening on port " + this.port);
            while (this.sock != null) {
                try {
                    new ClientThread(this, this.sock.accept()).start();
                }
                catch (IOException iOException) {}
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.log.info("Stopped listening");
        this.outThread.close();
        this.outThread = null;
    }

    @Override
    public InputStream getInputStream() {
        return this.pin;
    }

    @Override
    public OutputStream getOutputStream() {
        return this.pout;
    }

    @Override
    public void setConnectionListener(ConnectionListener listener) {
        this.listener = listener;
    }

    @Override
    public String toString() {
        return this.getName();
    }

    private class ClientThread
    extends Thread {
        Socket client;
        OutputStream out = null;
        TcpHubConnector conn;
        boolean negotiated = false;

        ClientThread(TcpHubConnector conn, Socket client) {
            this.setName(this.getClass().getSimpleName());
            this.setDaemon(true);
            this.conn = conn;
            this.client = client;
        }

        @Override
        public void run() {
            TcpHubConnector.this.clientThreads.add(this);
            String cname = "(unknown)";
            InputStream in = null;
            try {
                cname = this.client.getInetAddress().toString();
                TcpHubConnector.this.log.info("New connection from " + cname);
                in = this.client.getInputStream();
                this.out = this.client.getOutputStream();
                if (TcpHubConnector.this.telnet) {
                    int[] negotiationBytes;
                    for (int b : negotiationBytes = new int[]{255, 251, 1, 255, 251, 3, 255, 252, 34, 27, 91, 63, 50, 48, 48, 52, 104}) {
                        this.out.write(b);
                    }
                    this.out.flush();
                }
                if (TcpHubConnector.this.listener != null) {
                    TcpHubConnector.this.listener.connected(this.conn);
                }
                this.negotiated = true;
                boolean iac = false;
                int skip = 0;
                while (!Thread.interrupted()) {
                    int c = in.read();
                    if (skip > 0) {
                        --skip;
                        continue;
                    }
                    if (iac) {
                        if (c >= 251) {
                            skip = 1;
                        }
                        if (c == 255) continue;
                        iac = false;
                        continue;
                    }
                    if (TcpHubConnector.this.telnet && c == 255) {
                        iac = true;
                        continue;
                    }
                    if (!(c < 0 || TcpHubConnector.this.telnet && c == 4)) {
                        if (c <= 0) continue;
                        TcpHubConnector.this.pin.write(c);
                        continue;
                    }
                    break;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            TcpHubConnector.this.log.info("Connection from " + cname + " closed");
            this.close(in);
            this.close(this.out);
            this.close(this.client);
            TcpHubConnector.this.clientThreads.remove(this);
            this.client = null;
            this.out = null;
        }

        void write(int c) {
            if (!this.negotiated) {
                return;
            }
            try {
                if (this.out != null) {
                    this.out.write(c);
                    this.out.flush();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        void close() {
            this.close(this.client);
        }

        void close(Closeable x) {
            try {
                if (x != null) {
                    x.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private class OutputThread
    extends Thread {
        OutputThread() {
            this.setName(this.getClass().getSimpleName());
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (TcpHubConnector.this.pout != null && TcpHubConnector.this.pout.available() >= 0) {
                int c = TcpHubConnector.this.pout.read();
                if (c < 0) continue;
                List<ClientThread> list = TcpHubConnector.this.clientThreads;
                synchronized (list) {
                    for (ClientThread t : TcpHubConnector.this.clientThreads) {
                        t.write(c);
                    }
                }
            }
        }

        void close() {
            if (TcpHubConnector.this.pout != null) {
                TcpHubConnector.this.pout.close();
            }
        }
    }
}

