/*
 * Decompiled with CFR 0.152.
 */
package org.arl.fjage.connectors;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.UnknownHostException;
import java.util.logging.Logger;
import org.arl.fjage.connectors.ConnectionListener;
import org.arl.fjage.connectors.TcpConnector;

public class TcpServer
extends Thread
implements Closeable {
    protected int port;
    protected ServerSocket sock = null;
    protected ConnectionListener listener;
    protected Logger log = Logger.getLogger(this.getClass().getName());

    public TcpServer(int port, ConnectionListener listener) {
        this.port = port;
        this.listener = listener;
        this.setName("tcpserver:[listening on port " + port + "]");
        this.setDaemon(true);
        this.start();
    }

    public synchronized int getPort() {
        if (this.port == 0) {
            try {
                this.wait(100L);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                return -1;
            }
        }
        return this.port;
    }

    @Override
    public void close() {
        if (this.sock == null) {
            return;
        }
        try {
            this.sock.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.sock = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            TcpServer tcpServer = this;
            synchronized (tcpServer) {
                this.sock = new ServerSocket(this.port);
                this.port = this.sock.getLocalPort();
                this.notify();
            }
            try {
                this.setName("tcp://" + InetAddress.getLocalHost().getHostAddress() + ":" + this.port);
            }
            catch (UnknownHostException ex) {
                this.setName("tcp://0.0.0.0:" + this.port);
            }
            this.log.info("Listening on port " + this.port);
            while (this.sock != null) {
                try {
                    this.listener.connected(new TcpConnector(this.sock.accept()));
                }
                catch (IOException iOException) {}
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.log.info("Stopped listening");
    }

    @Override
    public String toString() {
        return this.getName();
    }
}

