/*
 * Decompiled with CFR 0.152.
 */
package org.arl.fjage.connectors;

import java.io.File;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.handler.DefaultHandler;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.server.handler.ResourceHandler;
import org.eclipse.jetty.server.handler.gzip.GzipHandler;
import org.eclipse.jetty.util.log.Log;

public class WebServer {
    public static final String NOCACHE = "no-cache, no-store, must-revalidate";
    public static final String CACHE = "public, max-age=31536000";
    private static Map<Integer, WebServer> servers = new HashMap<Integer, WebServer>();
    private static Logger log = Logger.getLogger(WebServer.class.getName());
    protected Server server;
    protected ContextHandlerCollection contexts;
    protected Map<String, ContextHandler> staticContexts = new HashMap<String, ContextHandler>();
    protected boolean started;
    protected int port;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WebServer getInstance(int port) {
        Map<Integer, WebServer> map = servers;
        synchronized (map) {
            WebServer svr = servers.get(port);
            if (svr == null || svr.server == null) {
                svr = new WebServer(port);
            }
            return svr;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WebServer getInstance(int port, String ip) {
        Map<Integer, WebServer> map = servers;
        synchronized (map) {
            WebServer svr = servers.get(port);
            if (svr == null || svr.server == null) {
                svr = new WebServer(port, ip);
            }
            return svr;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasInstance(int port) {
        Map<Integer, WebServer> map = servers;
        synchronized (map) {
            WebServer svr = servers.get(port);
            return svr != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WebServer[] getInstances() {
        Map<Integer, WebServer> map = servers;
        synchronized (map) {
            return servers.values().toArray(new WebServer[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shutdown() {
        Map<Integer, WebServer> map = servers;
        synchronized (map) {
            for (WebServer svr : servers.values()) {
                svr.stop();
            }
        }
    }

    protected WebServer(int port) {
        this(port, "127.0.0.1");
    }

    protected WebServer(int port, String ip) {
        this.port = port;
        this.server = new Server(InetSocketAddress.createUnresolved(ip, port));
        this.server.setStopAtShutdown(true);
        if (port > 0) {
            servers.put(port, this);
        }
        this.contexts = new ContextHandlerCollection();
        HandlerCollection handlerCollection = new HandlerCollection();
        GzipHandler gzipHandler = new GzipHandler();
        gzipHandler.setIncludedMimeTypes(new String[]{"text/html", "text/plain", "text/xml", "text/css", "application/javascript", "text/javascript"});
        handlerCollection.setHandlers(new Handler[]{this.contexts, new DefaultHandler()});
        gzipHandler.setHandler((Handler)handlerCollection);
        this.server.setHandler((Handler)gzipHandler);
        this.started = false;
    }

    public int getPort() {
        return this.port;
    }

    public void start() {
        if (this.started) {
            return;
        }
        try {
            this.server.start();
            log.info("Started web server on port " + this.port);
            this.started = true;
        }
        catch (Exception ex) {
            log.warning(ex.toString());
        }
    }

    public void stop() {
        if (this.server == null) {
            return;
        }
        try {
            log.info("Stopping web server");
            this.server.stop();
            this.started = false;
        }
        catch (Exception ex) {
            log.warning(ex.toString());
        }
        this.server = null;
        this.contexts = null;
        if (this.port > 0) {
            servers.remove(this.port);
        }
    }

    public void add(ContextHandler handler) {
        log.info("Adding web context: " + handler.getContextPath());
        this.contexts.addHandler((Handler)handler);
        try {
            handler.start();
        }
        catch (Exception ex) {
            log.warning("Unable to start context " + handler.getContextPath() + ": " + ex.toString());
        }
    }

    public void remove(ContextHandler handler) {
        log.info("Removing web context: " + handler.getContextPath());
        try {
            handler.stop();
        }
        catch (Exception ex) {
            log.warning("Unable to stop context " + handler.getContextPath() + ": " + ex.toString());
        }
        this.contexts.removeHandler((Handler)handler);
        if (this.contexts.getHandlers().length <= this.staticContexts.size()) {
            this.stop();
        }
    }

    public void add(String context, String resource, String cacheControl) {
        String staticWebResDir = this.getClass().getResource(resource).toExternalForm();
        ContextHandler handler = new ContextHandler(context);
        ResourceHandler resHandler = new ResourceHandler();
        resHandler.setResourceBase(staticWebResDir);
        resHandler.setWelcomeFiles(new String[]{"index.html"});
        resHandler.setDirectoriesListed(false);
        resHandler.setCacheControl(cacheControl);
        handler.setHandler((Handler)resHandler);
        this.staticContexts.put(context, handler);
        this.add(handler);
    }

    public void add(String context, String resource) {
        this.add(context, resource, CACHE);
    }

    public void add(String context, File dir, String cacheControl) {
        ContextHandler handler = new ContextHandler(context);
        ResourceHandler resHandler = new ResourceHandler();
        resHandler.setResourceBase(dir.getAbsolutePath());
        resHandler.setWelcomeFiles(new String[]{"index.html"});
        resHandler.setDirectoriesListed(false);
        resHandler.setCacheControl(cacheControl);
        handler.setHandler((Handler)resHandler);
        this.staticContexts.put(context, handler);
        this.add(handler);
    }

    public void add(String context, File dir) {
        this.add(context, dir, CACHE);
    }

    public void remove(String context) {
        ContextHandler handler = this.staticContexts.get(context);
        if (handler == null) {
            return;
        }
        this.staticContexts.remove(context);
        this.remove(handler);
    }

    public boolean hasContext(String context) {
        return this.staticContexts.get(context) != null;
    }

    static {
        System.setProperty("org.eclipse.jetty.LEVEL", "WARN");
        Log.setLog((org.eclipse.jetty.util.log.Logger)new org.eclipse.jetty.util.log.Logger(){

            public String getName() {
                return "[jetty]";
            }

            public org.eclipse.jetty.util.log.Logger getLogger(String name) {
                return this;
            }

            public boolean isDebugEnabled() {
                return false;
            }

            public void warn(String msg, Object ... args) {
                log.warning(msg);
            }

            public void warn(Throwable t) {
                log.warning(t.toString());
            }

            public void warn(String msg, Throwable thrown) {
                log.warning(msg);
            }

            public void info(String msg, Object ... args) {
            }

            public void info(Throwable thrown) {
            }

            public void info(String msg, Throwable thrown) {
            }

            public void setDebugEnabled(boolean enabled) {
            }

            public void debug(String msg, Object ... args) {
            }

            public void debug(String msg, long x) {
            }

            public void debug(Throwable thrown) {
            }

            public void debug(String msg, Throwable thrown) {
            }

            public void ignore(Throwable ignored) {
            }
        });
    }
}

