/*
 * Decompiled with CFR 0.152.
 */
package org.arl.fjage.connectors;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Logger;
import org.arl.fjage.connectors.ConnectionListener;
import org.arl.fjage.connectors.Connector;
import org.arl.fjage.connectors.PseudoInputStream;
import org.arl.fjage.connectors.PseudoOutputStream;
import org.arl.fjage.connectors.WebServer;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketClose;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketConnect;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketError;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketMessage;
import org.eclipse.jetty.websocket.api.annotations.WebSocket;
import org.eclipse.jetty.websocket.server.WebSocketHandler;
import org.eclipse.jetty.websocket.servlet.ServletUpgradeRequest;
import org.eclipse.jetty.websocket.servlet.ServletUpgradeResponse;
import org.eclipse.jetty.websocket.servlet.WebSocketCreator;
import org.eclipse.jetty.websocket.servlet.WebSocketServletFactory;

public class WebSocketConnector
implements Connector,
WebSocketCreator {
    protected String name;
    protected boolean linemode = false;
    protected WebServer server;
    protected ContextHandler handler;
    protected List<WSHandler> wsHandlers = new CopyOnWriteArrayList<WSHandler>();
    protected OutputThread outThread = null;
    protected PseudoInputStream pin = new PseudoInputStream();
    protected PseudoOutputStream pout = new PseudoOutputStream();
    protected ConnectionListener listener = null;
    protected Logger log = Logger.getLogger(this.getClass().getName());

    public WebSocketConnector(int port, String context) {
        this.init(port, context, -1);
    }

    public WebSocketConnector(int port, String context, boolean linemode) {
        this.init(port, context, -1);
        this.linemode = linemode;
    }

    public WebSocketConnector(int port, String context, int maxMsgSize) {
        this.init(port, context, maxMsgSize);
    }

    public WebSocketConnector(int port, String context, boolean linemode, int maxMsgSize) {
        this.init(port, context, maxMsgSize);
        this.linemode = linemode;
    }

    protected void init(int port, String context, final int maxMsgSize) {
        try {
            this.name = "ws://" + InetAddress.getLocalHost().getHostAddress() + ":" + port + context;
        }
        catch (UnknownHostException ex) {
            this.name = "ws://0.0.0.0:" + port + context;
        }
        this.server = WebServer.getInstance(port);
        this.handler = new ContextHandler(context);
        this.handler.setHandler((Handler)new WebSocketHandler(){

            public void configure(WebSocketServletFactory factory) {
                factory.setCreator((WebSocketCreator)WebSocketConnector.this);
                if (maxMsgSize > 0) {
                    factory.getPolicy().setMaxTextMessageSize(maxMsgSize);
                }
            }
        });
        this.server.add(this.handler);
        this.server.start();
        this.outThread = new OutputThread();
        this.outThread.start();
    }

    public Object createWebSocket(ServletUpgradeRequest req, ServletUpgradeResponse resp) {
        return new WSHandler(this);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public InputStream getInputStream() {
        return this.pin;
    }

    @Override
    public OutputStream getOutputStream() {
        return this.pout;
    }

    @Override
    public void setConnectionListener(ConnectionListener listener) {
        this.listener = listener;
    }

    @Override
    public boolean isReliable() {
        return true;
    }

    @Override
    public boolean waitOutputCompletion(long timeout) {
        return true;
    }

    @Override
    public void close() {
        this.outThread.close();
        this.outThread = null;
        this.server.remove(this.handler);
        this.server = null;
        this.handler = null;
        this.pin.close();
        this.pout.close();
        this.pin = null;
        this.pout = null;
    }

    public String toString() {
        return this.name;
    }

    @WebSocket(maxIdleTime=0x7FFFFFFF)
    public class WSHandler {
        Session session = null;
        WebSocketConnector conn;

        public WSHandler(WebSocketConnector conn) {
            this.conn = conn;
        }

        @OnWebSocketConnect
        public void onConnect(Session session) {
            WebSocketConnector.this.log.fine("New connection from " + session.getRemoteAddress());
            this.session = session;
            WebSocketConnector.this.wsHandlers.add(this);
            if (WebSocketConnector.this.listener != null) {
                WebSocketConnector.this.listener.connected(this.conn);
            }
        }

        @OnWebSocketClose
        public void onClose(int statusCode, String reason) {
            WebSocketConnector.this.log.fine("Connection from " + this.session.getRemoteAddress() + " closed");
            this.session = null;
            WebSocketConnector.this.wsHandlers.remove(this);
        }

        @OnWebSocketError
        public void onError(Throwable t) {
            WebSocketConnector.this.log.warning(t.getMessage());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @OnWebSocketMessage
        public void onMessage(String message) {
            byte[] buf = message.getBytes();
            PseudoInputStream pseudoInputStream = WebSocketConnector.this.pin;
            synchronized (pseudoInputStream) {
                for (int i = 0; i < buf.length; ++i) {
                    int c = buf[i];
                    if (c < 0) {
                        c += 256;
                    }
                    if (c == 4) continue;
                    try {
                        WebSocketConnector.this.pin.write(c);
                        continue;
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        }

        void write(String s) {
            try {
                if (this.session != null) {
                    this.session.getRemote().sendString(s);
                }
            }
            catch (Exception e) {
                WebSocketConnector.this.log.warning(e.getMessage());
            }
        }
    }

    private class OutputThread
    extends Thread {
        OutputThread() {
            this.setName(this.getClass().getSimpleName() + ":" + WebSocketConnector.this.name);
            this.setDaemon(true);
            this.setPriority(1);
        }

        @Override
        public void run() {
            while (true) {
                Object buf;
                String s;
                if (WebSocketConnector.this.linemode) {
                    s = WebSocketConnector.this.pout.readLine();
                    if (s == null) {
                        break;
                    }
                } else {
                    buf = WebSocketConnector.this.pout.readAvailable();
                    if (buf == null) break;
                    s = new String((byte[])buf);
                }
                buf = WebSocketConnector.this.wsHandlers.iterator();
                while (buf.hasNext()) {
                    WSHandler t = (WSHandler)buf.next();
                    t.write(s);
                }
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException ex) {
                    break;
                }
            }
        }

        void close() {
            try {
                if (WebSocketConnector.this.pout != null) {
                    WebSocketConnector.this.pout.close();
                    this.join();
                }
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
        }
    }
}

