/*
 * Decompiled with CFR 0.152.
 */
package org.arl.fjage.param;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import org.apache.commons.lang3.reflect.MethodUtils;
import org.arl.fjage.Message;
import org.arl.fjage.MessageBehavior;
import org.arl.fjage.OneShotBehavior;
import org.arl.fjage.param.NamedParameter;
import org.arl.fjage.param.Parameter;
import org.arl.fjage.param.ParameterReq;
import org.arl.fjage.param.ParameterRsp;

public class ParameterMessageBehavior
extends MessageBehavior {
    private List<? extends Parameter> params;

    public ParameterMessageBehavior() {
        super(ParameterReq.class);
        this.params = null;
    }

    public ParameterMessageBehavior(List<? extends Parameter> params) {
        super(ParameterReq.class);
        this.params = params;
    }

    public ParameterMessageBehavior(Class ... paramEnumClasses) {
        super(ParameterReq.class);
        this.params = new ArrayList<Parameter>();
        for (int i = 0; i < paramEnumClasses.length; ++i) {
            this.params.addAll(EnumSet.allOf(paramEnumClasses[i]));
        }
    }

    @Override
    public void onReceive(Message msg) {
        final ParameterReq req = (ParameterReq)msg;
        this.agent.add(new OneShotBehavior(){

            @Override
            public void action() {
                ParameterRsp rsp = ParameterMessageBehavior.this.processParameterReq(req, null);
                if (rsp != null) {
                    this.agent.send(rsp);
                }
            }
        });
    }

    protected List<? extends Parameter> getParameterList() {
        return this.params;
    }

    protected List<? extends Parameter> getParameterList(int ndx) {
        if (ndx < 0) {
            return this.getParameterList();
        }
        return null;
    }

    protected Object getParam(Parameter p, int ndx) {
        return null;
    }

    protected Object setParam(Parameter p, int ndx, Object v) {
        return null;
    }

    protected void onParamChange(Parameter p, int ndx, Object v) {
    }

    protected boolean isReadOnly(Parameter p, int ndx) {
        String fldName = p.toString();
        String methodNameFragment = fldName.substring(0, 1).toUpperCase() + fldName.substring(1);
        if (this.isCallable("set" + methodNameFragment, ndx < 0 ? 1 : 2)) {
            return false;
        }
        if (ndx < 0) {
            try {
                Field f = this.agent.getClass().getField(fldName);
                int mod = f.getModifiers();
                if (Modifier.isPublic(mod) && !Modifier.isFinal(mod)) {
                    return false;
                }
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
        }
        return true;
    }

    protected static List<? extends Parameter> allOf(Class ... paramEnumClasses) {
        ArrayList p = new ArrayList();
        for (int i = 0; i < paramEnumClasses.length; ++i) {
            p.addAll(EnumSet.allOf(paramEnumClasses[i]));
        }
        return p;
    }

    protected ParameterRsp processParameterReq(ParameterReq msg, ParameterRsp rsp) {
        if (rsp == null) {
            rsp = new ParameterRsp(msg);
        }
        int ndx = msg.getIndex();
        List<? extends Parameter> plist = null;
        if (msg.requests().isEmpty()) {
            List<? extends Parameter> list = plist = ndx < 0 ? this.getParameterList() : this.getParameterList(ndx);
            if (plist != null) {
                msg.get(plist);
            }
            msg.get(new NamedParameter("title"));
            msg.get(new NamedParameter("description"));
        }
        Class<?> cls = this.agent.getClass();
        for (ParameterReq.Entry e : msg.requests()) {
            if (e.param instanceof NamedParameter) {
                if (plist == null) {
                    List<? extends Parameter> list = plist = ndx < 0 ? this.getParameterList() : this.getParameterList(ndx);
                    if (plist == null) {
                        plist = new ArrayList<Parameter>(1);
                    }
                }
                for (Parameter parameter : plist) {
                    if (!parameter.toString().equals(e.param.toString())) continue;
                    e.param = parameter;
                    break;
                }
            }
            try {
                Field f;
                Object rv;
                String fldName = e.param.toString();
                String string = fldName.substring(0, 1).toUpperCase() + fldName.substring(1);
                Object evalue = e.getValue();
                if (evalue == null) {
                    try {
                        if (fldName.equals("type")) {
                            rsp.set(e.param, this.agent.getClass().getName(), true);
                            continue;
                        }
                        if (ndx < 0) {
                            rsp.set(e.param, MethodUtils.invokeMethod((Object)this.agent, (String)("get" + string)), this.isReadOnly(e.param, ndx));
                            continue;
                        }
                        rsp.set(e.param, MethodUtils.invokeMethod((Object)this.agent, (String)("get" + string), (Object[])new Object[]{ndx}), this.isReadOnly(e.param, ndx));
                    }
                    catch (NoSuchMethodException ex) {
                        rv = this.getParam(e.param, ndx);
                        if (rv != null) {
                            rsp.set(e.param, rv, this.isReadOnly(e.param, ndx));
                            continue;
                        }
                        if (ndx >= 0) {
                            throw ex;
                        }
                        f = cls.getField(fldName);
                        rsp.set(e.param, f.get(this.agent), this.isReadOnly(e.param, ndx));
                    }
                    continue;
                }
                try {
                    Object sv;
                    block26: {
                        Object m = null;
                        sv = null;
                        sv = ndx < 0 ? this.invokeCompatibleSetter("set" + string, evalue) : this.invokeCompatibleSetter("set" + string, ndx, evalue);
                        if (sv == null) {
                            try {
                                sv = ndx < 0 ? MethodUtils.invokeMethod((Object)this.agent, (String)("get" + string)) : MethodUtils.invokeMethod((Object)this.agent, (String)("get" + string), (Object[])new Object[]{ndx});
                            }
                            catch (NoSuchMethodException ex) {
                                sv = this.getParam(e.param, ndx);
                                if (sv != null) break block26;
                                sv = evalue;
                            }
                        }
                    }
                    if (sv == null) continue;
                    rsp.set(e.param, sv, false);
                    this.onParamChange(e.param, ndx, sv);
                }
                catch (NoSuchMethodException ex) {
                    rv = this.setParam(e.param, ndx, evalue);
                    if (rv != null) {
                        rsp.set(e.param, rv, this.isReadOnly(e.param, ndx));
                        this.onParamChange(e.param, ndx, rv);
                        continue;
                    }
                    if (ndx >= 0) {
                        throw ex;
                    }
                    f = cls.getField(fldName);
                    boolean ro = false;
                    try {
                        f.set(this.agent, evalue);
                    }
                    catch (IllegalAccessException ex1) {
                        ro = true;
                    }
                    rv = f.get(this.agent);
                    rsp.set(e.param, rv, ro);
                    this.onParamChange(e.param, ndx, rv);
                }
            }
            catch (Exception exception) {}
        }
        return rsp;
    }

    private double[] asDoubleArray(List<?> a) {
        try {
            double[] x = new double[a.size()];
            for (int i = 0; i < a.size(); ++i) {
                x[i] = ((Number)a.get(i)).doubleValue();
            }
            return x;
        }
        catch (Exception ex) {
            throw new ArrayStoreException();
        }
    }

    private float[] asFloatArray(List<?> a) {
        try {
            float[] x = new float[a.size()];
            for (int i = 0; i < a.size(); ++i) {
                x[i] = ((Number)a.get(i)).floatValue();
            }
            return x;
        }
        catch (Exception ex) {
            throw new ArrayStoreException();
        }
    }

    private long[] asLongArray(List<?> a) {
        try {
            long[] x = new long[a.size()];
            for (int i = 0; i < a.size(); ++i) {
                x[i] = ((Number)a.get(i)).longValue();
            }
            return x;
        }
        catch (Exception ex) {
            throw new ArrayStoreException();
        }
    }

    private int[] asIntArray(List<?> a) {
        try {
            int[] x = new int[a.size()];
            for (int i = 0; i < a.size(); ++i) {
                x[i] = ((Number)a.get(i)).intValue();
            }
            return x;
        }
        catch (Exception ex) {
            throw new ArrayStoreException();
        }
    }

    private Object invokeCompatibleSetter(String name, Object value) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        NoSuchMethodException nsme = null;
        try {
            return MethodUtils.invokeMethod((Object)this.agent, (String)name, (Object[])new Object[]{value});
        }
        catch (NoSuchMethodException ex) {
            nsme = ex;
            if (value instanceof Number) {
                Number nvalue = (Number)value;
                try {
                    return MethodUtils.invokeMethod((Object)this.agent, (String)name, (Object[])new Object[]{nvalue.doubleValue()});
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    try {
                        return MethodUtils.invokeMethod((Object)this.agent, (String)name, (Object[])new Object[]{Float.valueOf(nvalue.floatValue())});
                    }
                    catch (NoSuchMethodException noSuchMethodException2) {
                        try {
                            return MethodUtils.invokeMethod((Object)this.agent, (String)name, (Object[])new Object[]{nvalue.longValue()});
                        }
                        catch (NoSuchMethodException noSuchMethodException3) {
                            try {
                                return MethodUtils.invokeMethod((Object)this.agent, (String)name, (Object[])new Object[]{nvalue.intValue()});
                            }
                            catch (NoSuchMethodException noSuchMethodException4) {
                                // empty catch block
                            }
                        }
                    }
                }
            }
            if (value instanceof List) {
                List lvalue = (List)value;
                try {
                    return MethodUtils.invokeMethod((Object)this.agent, (String)name, (Object[])new Object[]{this.asDoubleArray(lvalue)});
                }
                catch (ArrayStoreException | NoSuchMethodException exception) {
                    try {
                        return MethodUtils.invokeMethod((Object)this.agent, (String)name, (Object[])new Object[]{this.asFloatArray(lvalue)});
                    }
                    catch (ArrayStoreException | NoSuchMethodException exception2) {
                        try {
                            return MethodUtils.invokeMethod((Object)this.agent, (String)name, (Object[])new Object[]{this.asLongArray(lvalue)});
                        }
                        catch (ArrayStoreException | NoSuchMethodException exception3) {
                            try {
                                return MethodUtils.invokeMethod((Object)this.agent, (String)name, (Object[])new Object[]{this.asIntArray(lvalue)});
                            }
                            catch (ArrayStoreException | NoSuchMethodException exception4) {
                                try {
                                    return MethodUtils.invokeMethod((Object)this.agent, (String)name, (Object[])new Object[]{lvalue.toArray(new String[0])});
                                }
                                catch (ArrayStoreException | NoSuchMethodException exception5) {
                                    // empty catch block
                                }
                            }
                        }
                    }
                }
            }
            throw nsme;
        }
    }

    private Object invokeCompatibleSetter(String name, int ndx, Object value) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        NoSuchMethodException nsme = null;
        try {
            return MethodUtils.invokeMethod((Object)this.agent, (String)name, (Object[])new Object[]{ndx, value});
        }
        catch (NoSuchMethodException ex) {
            nsme = ex;
            if (value instanceof Number) {
                Number nvalue = (Number)value;
                try {
                    return MethodUtils.invokeMethod((Object)this.agent, (String)name, (Object[])new Object[]{ndx, nvalue.doubleValue()});
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    try {
                        return MethodUtils.invokeMethod((Object)this.agent, (String)name, (Object[])new Object[]{ndx, Float.valueOf(nvalue.floatValue())});
                    }
                    catch (NoSuchMethodException noSuchMethodException2) {
                        try {
                            return MethodUtils.invokeMethod((Object)this.agent, (String)name, (Object[])new Object[]{ndx, nvalue.longValue()});
                        }
                        catch (NoSuchMethodException noSuchMethodException3) {
                            try {
                                return MethodUtils.invokeMethod((Object)this.agent, (String)name, (Object[])new Object[]{ndx, nvalue.intValue()});
                            }
                            catch (NoSuchMethodException noSuchMethodException4) {
                                // empty catch block
                            }
                        }
                    }
                }
            }
            if (value instanceof List) {
                List lvalue = (List)value;
                try {
                    return MethodUtils.invokeMethod((Object)this.agent, (String)name, (Object[])new Object[]{ndx, this.asDoubleArray(lvalue)});
                }
                catch (ArrayStoreException | NoSuchMethodException exception) {
                    try {
                        return MethodUtils.invokeMethod((Object)this.agent, (String)name, (Object[])new Object[]{ndx, this.asFloatArray(lvalue)});
                    }
                    catch (ArrayStoreException | NoSuchMethodException exception2) {
                        try {
                            return MethodUtils.invokeMethod((Object)this.agent, (String)name, (Object[])new Object[]{ndx, this.asLongArray(lvalue)});
                        }
                        catch (ArrayStoreException | NoSuchMethodException exception3) {
                            try {
                                return MethodUtils.invokeMethod((Object)this.agent, (String)name, (Object[])new Object[]{ndx, this.asIntArray(lvalue)});
                            }
                            catch (ArrayStoreException | NoSuchMethodException exception4) {
                                try {
                                    return MethodUtils.invokeMethod((Object)this.agent, (String)name, (Object[])new Object[]{ndx, lvalue.toArray(new String[0])});
                                }
                                catch (ArrayStoreException | NoSuchMethodException exception5) {
                                    // empty catch block
                                }
                            }
                        }
                    }
                }
            }
            throw nsme;
        }
    }

    private boolean isCallable(String methodName, int params) {
        Class<?> cls = this.agent.getClass();
        for (Method m : cls.getMethods()) {
            int mod;
            if (!m.getName().equals(methodName) || m.getParameterCount() != params || !Modifier.isPublic(mod = m.getModifiers()) || Modifier.isAbstract(mod)) continue;
            if (params == 1) {
                return true;
            }
            Class<?>[] p = m.getParameterTypes();
            if (!p[0].equals(Integer.class) && !p[0].equals(Integer.TYPE)) continue;
            return true;
        }
        return false;
    }
}

