/*
 * Decompiled with CFR 0.152.
 */
package org.arl.fjage.param;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.arl.fjage.AgentID;
import org.arl.fjage.GenericValue;
import org.arl.fjage.Message;
import org.arl.fjage.Performative;
import org.arl.fjage.param.Parameter;

public class ParameterReq
extends Message {
    private static final long serialVersionUID = 1L;
    protected int index = -1;
    protected List<Entry> requests = null;
    protected Parameter param;
    protected GenericValue value;

    public ParameterReq() {
        super(Performative.REQUEST);
    }

    public ParameterReq(AgentID recipient) {
        super(recipient, Performative.REQUEST);
    }

    public void clear() {
        this.requests = null;
        this.param = null;
        this.value = null;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public ParameterReq get(Parameter param) {
        if (this.param == null) {
            this.param = param;
        } else {
            if (this.requests == null) {
                this.requests = new ArrayList<Entry>();
            }
            this.requests.add(new Entry(param, null));
        }
        return this;
    }

    public ParameterReq get(List<? extends Parameter> param) {
        for (Parameter parameter : param) {
            this.get(parameter);
        }
        return this;
    }

    public ParameterReq set(Parameter param, Object value) {
        if (this.param == null) {
            this.param = param;
            this.value = new GenericValue(value);
        } else {
            if (this.requests == null) {
                this.requests = new ArrayList<Entry>();
            }
            this.requests.add(new Entry(param, value));
        }
        return this;
    }

    public List<Entry> requests() {
        int n = 0;
        if (this.requests != null) {
            n = this.requests.size();
        }
        ArrayList<Entry> rq = new ArrayList<Entry>(n + 1);
        if (this.param != null) {
            rq.add(new Entry(this.param, this.value));
        }
        if (this.requests != null) {
            rq.addAll(this.requests);
        }
        return rq;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getSimpleName());
        sb.append('[');
        if (this.index >= 0) {
            sb.append("index:");
            sb.append(this.index);
            if (this.param != null) {
                sb.append(' ');
            }
        }
        if (this.param != null) {
            sb.append(this.param);
            sb.append(':');
            sb.append(this.value == null ? Character.valueOf('?') : this.value);
            if (this.requests != null) {
                for (Entry e : this.requests) {
                    sb.append(' ');
                    sb.append(e.param);
                    sb.append(':');
                    Object evalue = e.getValue();
                    sb.append(evalue == null ? Character.valueOf('?') : evalue);
                }
            }
        }
        sb.append(']');
        return sb.toString();
    }

    public class Entry
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public Parameter param;
        public GenericValue value;

        private Entry(Parameter param, Object value) {
            this.param = param;
            this.value = value == null ? null : (value instanceof GenericValue ? (GenericValue)value : new GenericValue(value));
        }

        public Object getValue() {
            if (this.value == null) {
                return null;
            }
            return this.value.getValue();
        }
    }
}

