/*
 * Decompiled with CFR 0.152.
 */
package org.arl.fjage.param;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.arl.fjage.GenericValue;
import org.arl.fjage.Message;
import org.arl.fjage.Performative;
import org.arl.fjage.param.Parameter;

public class ParameterRsp
extends Message {
    private static final long serialVersionUID = 1L;
    protected int index = -1;
    protected Map<Parameter, GenericValue> values = null;
    protected Parameter param;
    protected GenericValue value;
    protected Set<Parameter> readonly = new HashSet<Parameter>();

    public ParameterRsp(Message msg) {
        super(msg, Performative.INFORM);
    }

    public void clear() {
        this.param = null;
        this.value = null;
        this.values = null;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public void set(Parameter param, Object value, boolean readonly) {
        if (this.param == null) {
            this.param = param;
            this.value = new GenericValue(value);
        } else {
            if (this.values == null) {
                this.values = new HashMap<Parameter, GenericValue>();
            }
            this.values.put(param, new GenericValue(value));
        }
        if (readonly) {
            this.readonly.add(param);
        }
    }

    public Object get(Parameter param) {
        if (this.param == null) {
            return null;
        }
        Object rv = null;
        if (this.param.equals(param)) {
            if (this.value == null) {
                return null;
            }
            rv = this.value.getValue();
        } else {
            if (this.values == null) {
                return null;
            }
            GenericValue v = this.values.get(param);
            if (v == null) {
                return null;
            }
            rv = v.getValue();
        }
        if (rv instanceof Double && (double)((Double)rv).intValue() == (Double)rv) {
            rv = new Integer(((Double)rv).intValue());
        }
        return rv;
    }

    public boolean isReadonly(Parameter param) {
        return this.readonly.contains(param);
    }

    public Set<Parameter> parameters() {
        HashSet<Parameter> set = new HashSet<Parameter>();
        if (this.param != null) {
            set.add(this.param);
        }
        if (this.values != null) {
            set.addAll(this.values.keySet());
        }
        return set;
    }

    public Map<Parameter, Object> getParameters() {
        HashMap<Parameter, Object> map = new HashMap<Parameter, Object>();
        if (this.param != null) {
            map.put(this.param, this.value);
        }
        if (this.values != null) {
            map.putAll(this.values);
        }
        return map;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getSimpleName());
        sb.append('[');
        if (this.index >= 0) {
            sb.append("index:");
            sb.append(this.index);
            if (this.param != null) {
                sb.append(' ');
            }
        }
        String s = null;
        Object v = null;
        if (this.param != null) {
            sb.append(this.param);
            if (this.isReadonly(this.param)) {
                sb.append('*');
            }
            sb.append(':');
            if (this.value != null) {
                v = this.value.getValue();
                if (v instanceof Double && (double)((Double)v).intValue() == (Double)v) {
                    v = new Integer(((Double)v).intValue());
                }
                sb.append(v);
            } else {
                sb.append("null");
            }
            if (this.values != null) {
                for (Map.Entry<Parameter, GenericValue> e : this.values.entrySet()) {
                    sb.append(' ');
                    sb.append(e.getKey());
                    sb.append(':');
                    GenericValue gv = e.getValue();
                    v = null;
                    if (gv != null) {
                        v = gv.getValue();
                    }
                    if (v instanceof Double && (double)((Double)v).intValue() == (Double)v) {
                        v = new Integer(((Double)v).intValue());
                    }
                    sb.append(v);
                }
            }
            if ((s = sb.toString()).length() == 0) {
                s = null;
            }
        }
        sb.append(']');
        return sb.toString();
    }
}

