/*
 * Decompiled with CFR 0.152.
 */
package org.arl.fjage.persistence;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.arl.fjage.Agent;
import org.arl.fjage.FjageException;

public class Store
implements Closeable {
    protected static File storeRoot = new File(FileUtils.getUserDirectory(), ".fjstore");
    protected static ClassLoader defaultClazzLoader = null;
    protected static Map<String, Store> instances = new HashMap<String, Store>();
    protected File root;
    protected String clazz;
    protected ClassLoader clazzLoader;
    private MessageDigest md;

    protected Store(String clazz) {
        this.clazz = clazz;
        this.clazzLoader = defaultClazzLoader;
        try {
            this.md = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException ex) {
            throw new FjageException("SHA-256 not available");
        }
        this.root = new File(storeRoot, clazz);
    }

    public static void setRoot(File folder) {
        storeRoot = folder;
    }

    public static void setClassLoader(ClassLoader cl) {
        defaultClazzLoader = cl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Store getInstance(Agent agent) {
        String clazz = agent.getClass().getName();
        Map<String, Store> map = instances;
        synchronized (map) {
            Store store = instances.get(clazz);
            if (store == null) {
                store = new Store(clazz);
                instances.put(clazz, store);
            }
            return store;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String sha(byte[] input) {
        MessageDigest messageDigest = this.md;
        synchronized (messageDigest) {
            byte[] digest = this.md.digest(input);
            BigInteger num = new BigInteger(1, digest);
            return num.toString(16);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getId(Serializable obj) {
        Class<?> cls = obj.getClass();
        try {
            Method m = cls.getMethod("getId", new Class[0]);
            return m.invoke((Object)obj, new Object[0]).toString();
        }
        catch (Exception m) {
            String string;
            ByteArrayOutputStream baos = null;
            ObjectOutputStream oos = null;
            try {
                baos = new ByteArrayOutputStream();
                oos = new ObjectOutputStream(baos);
                oos.writeObject(obj);
                string = this.sha(baos.toByteArray());
            }
            catch (Exception ex) {
                String string2;
                try {
                    string2 = String.valueOf(obj.hashCode());
                }
                catch (Throwable throwable) {
                    Store.closeQuietly(oos);
                    Store.closeQuietly(baos);
                    throw throwable;
                }
                Store.closeQuietly(oos);
                Store.closeQuietly(baos);
                return string2;
            }
            Store.closeQuietly(oos);
            Store.closeQuietly(baos);
            return string;
        }
    }

    public void put(Serializable obj) {
        if (this.root == null) {
            throw new FjageException("Store has been closed");
        }
        File d = new File(this.root, obj.getClass().getName());
        d.mkdirs();
        File f = new File(d, this.getId(obj));
        FileOutputStream fout = null;
        ObjectOutputStream out = null;
        try {
            fout = new FileOutputStream(f);
            out = new ObjectOutputStream(fout);
            out.writeObject(obj);
            out.flush();
            fout.getFD().sync();
        }
        catch (Exception ex) {
            try {
                throw new FjageException(ex.toString());
            }
            catch (Throwable throwable) {
                Store.closeQuietly(out);
                Store.closeQuietly(fout);
                throw throwable;
            }
        }
        Store.closeQuietly(out);
        Store.closeQuietly(fout);
    }

    /*
     * Loose catch block
     */
    protected <T> T load(Class<T> type, File f) {
        Object object;
        FileInputStream fin = null;
        ObjectInputStream in = null;
        try {
            Object rv;
            fin = new FileInputStream(f);
            in = this.clazzLoader == null ? new ObjectInputStream(fin) : new ObjectInputStream(fin){

                @Override
                protected Class<?> resolveClass(ObjectStreamClass objectStreamClass) throws IOException, ClassNotFoundException {
                    Class<?> clazz = Class.forName(objectStreamClass.getName(), false, Store.this.clazzLoader);
                    if (clazz != null) {
                        return clazz;
                    }
                    return super.resolveClass(objectStreamClass);
                }
            };
            object = rv = in.readObject();
            Store.closeQuietly(in);
        }
        catch (IOException ex) {
            T t = null;
            return t;
        }
        catch (Exception ex2) {
            throw new FjageException(ex2.toString());
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            Store.closeQuietly(in);
            Store.closeQuietly(fin);
        }
        Store.closeQuietly(fin);
        return (T)object;
    }

    public <T> T getById(Class<T> type, String id) {
        if (this.root == null) {
            throw new FjageException("Store has been closed");
        }
        File f = new File(new File(this.root, type.getName()), id);
        return this.load(type, f);
    }

    public <T> List<T> getByType(Class<T> type) {
        if (this.root == null) {
            throw new FjageException("Store has been closed");
        }
        ArrayList<T> out = new ArrayList<T>();
        File[] list = new File(this.root, type.getName()).listFiles();
        if (list == null) {
            return out;
        }
        for (int i = 0; i < list.length; ++i) {
            T obj = this.load(type, list[i]);
            if (obj == null) continue;
            out.add(obj);
        }
        return out;
    }

    public boolean remove(Serializable obj) {
        return this.removeById(obj.getClass(), this.getId(obj));
    }

    public <T> boolean removeById(Class<T> type, String id) {
        if (this.root == null) {
            throw new FjageException("Store has been closed");
        }
        File f = new File(new File(this.root, type.getName()), id);
        return f.delete();
    }

    public <T> boolean removeByType(Class<T> type) {
        if (this.root == null) {
            throw new FjageException("Store has been closed");
        }
        try {
            File f = new File(this.root, type.getName());
            FileUtils.deleteDirectory((File)f);
            return true;
        }
        catch (IOException ex) {
            return false;
        }
    }

    public boolean delete() {
        if (this.root == null) {
            throw new FjageException("Store has been closed");
        }
        try {
            FileUtils.deleteDirectory((File)this.root);
            this.close();
            return true;
        }
        catch (IOException ex) {
            return false;
        }
    }

    public long size() {
        if (this.root == null) {
            throw new FjageException("Store has been closed");
        }
        try {
            return FileUtils.sizeOfDirectory((File)this.root);
        }
        catch (IllegalArgumentException ex) {
            return 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.root == null) {
            return;
        }
        Map<String, Store> map = instances;
        synchronized (map) {
            instances.remove(this.clazz);
        }
        this.clazz = null;
        this.root = null;
    }

    protected static void closeQuietly(InputStream is) {
        if (is == null) {
            return;
        }
        try {
            is.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected static void closeQuietly(OutputStream os) {
        if (os == null) {
            return;
        }
        try {
            os.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

