/*
 * Decompiled with CFR 0.152.
 */
package org.arl.fjage.remote;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.util.Base64;

class ArrayAdapterFactory
implements TypeAdapterFactory {
    private boolean bare;

    public ArrayAdapterFactory() {
        this.bare = false;
    }

    public ArrayAdapterFactory(boolean bare) {
        this.bare = bare;
    }

    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
        final Class rawType = type.getRawType();
        if (!rawType.isArray()) {
            return null;
        }
        final Class<?> compType = rawType.getComponentType();
        if (compType == null) {
            return null;
        }
        if (!compType.isPrimitive()) {
            return null;
        }
        if (!(compType.equals(Byte.TYPE) || compType.equals(Integer.TYPE) || compType.equals(Short.TYPE) || compType.equals(Long.TYPE) || compType.equals(Float.TYPE) || compType.equals(Double.TYPE))) {
            return null;
        }
        final TypeAdapter delegate = gson.getDelegateAdapter((TypeAdapterFactory)this, type);
        return new TypeAdapter<T>(){

            public void write(JsonWriter out, T value) throws IOException {
                if (value == null) {
                    out.nullValue();
                } else {
                    byte[] data;
                    if (compType.equals(Byte.TYPE)) {
                        data = (byte[])value;
                    } else {
                        ByteBuffer buf = null;
                        if (compType.equals(Integer.TYPE)) {
                            buf = ByteBuffer.allocate(4 * ((int[])value).length).order(ByteOrder.LITTLE_ENDIAN);
                            buf.asIntBuffer().put((int[])value);
                        } else if (compType.equals(Short.TYPE)) {
                            buf = ByteBuffer.allocate(2 * ((short[])value).length).order(ByteOrder.LITTLE_ENDIAN);
                            buf.asShortBuffer().put((short[])value);
                        } else if (compType.equals(Long.TYPE)) {
                            buf = ByteBuffer.allocate(8 * ((long[])value).length).order(ByteOrder.LITTLE_ENDIAN);
                            buf.asLongBuffer().put((long[])value);
                        } else if (compType.equals(Float.TYPE)) {
                            buf = ByteBuffer.allocate(4 * ((float[])value).length).order(ByteOrder.LITTLE_ENDIAN);
                            buf.asFloatBuffer().put((float[])value);
                        } else if (compType.equals(Double.TYPE)) {
                            buf = ByteBuffer.allocate(8 * ((double[])value).length).order(ByteOrder.LITTLE_ENDIAN);
                            buf.asDoubleBuffer().put((double[])value);
                        }
                        data = buf.array();
                    }
                    if (ArrayAdapterFactory.this.bare) {
                        out.value(Base64.getEncoder().encodeToString(data));
                    } else {
                        out.beginObject();
                        out.name("clazz").value(rawType.getName());
                        out.name("data").value(Base64.getEncoder().encodeToString(data));
                        out.endObject();
                    }
                }
            }

            public T read(JsonReader in) throws IOException {
                JsonToken tok = in.peek();
                if (tok == JsonToken.NULL) {
                    in.nextNull();
                    return null;
                }
                if (tok == JsonToken.STRING) {
                    return this.decodeString(in.nextString());
                }
                if (tok == JsonToken.BEGIN_ARRAY) {
                    return delegate.read(in);
                }
                if (tok != JsonToken.BEGIN_OBJECT) {
                    return null;
                }
                Object rv = null;
                in.beginObject();
                while (in.hasNext()) {
                    String name = in.nextName();
                    if (name.equals("data")) {
                        rv = this.decodeString(in.nextString());
                        continue;
                    }
                    in.skipValue();
                }
                in.endObject();
                return rv;
            }

            private T decodeString(String s) {
                byte[] data = Base64.getDecoder().decode(s);
                if (compType.equals(Byte.TYPE)) {
                    return data;
                }
                ByteBuffer buf = ByteBuffer.wrap(data);
                if (compType.equals(Integer.TYPE)) {
                    IntBuffer buf2 = ByteBuffer.wrap(Base64.getDecoder().decode(s)).order(ByteOrder.LITTLE_ENDIAN).asIntBuffer();
                    int[] array = new int[buf2.limit()];
                    buf2.get(array);
                    return array;
                }
                if (compType.equals(Short.TYPE)) {
                    ShortBuffer buf2 = ByteBuffer.wrap(Base64.getDecoder().decode(s)).order(ByteOrder.LITTLE_ENDIAN).asShortBuffer();
                    short[] array = new short[buf2.limit()];
                    buf2.get(array);
                    return array;
                }
                if (compType.equals(Long.TYPE)) {
                    LongBuffer buf2 = ByteBuffer.wrap(Base64.getDecoder().decode(s)).order(ByteOrder.LITTLE_ENDIAN).asLongBuffer();
                    long[] array = new long[buf2.limit()];
                    buf2.get(array);
                    return array;
                }
                if (compType.equals(Float.TYPE)) {
                    FloatBuffer buf2 = ByteBuffer.wrap(Base64.getDecoder().decode(s)).order(ByteOrder.LITTLE_ENDIAN).asFloatBuffer();
                    float[] array = new float[buf2.limit()];
                    buf2.get(array);
                    return array;
                }
                if (compType.equals(Double.TYPE)) {
                    DoubleBuffer buf2 = ByteBuffer.wrap(Base64.getDecoder().decode(s)).order(ByteOrder.LITTLE_ENDIAN).asDoubleBuffer();
                    double[] array = new double[buf2.limit()];
                    buf2.get(array);
                    return array;
                }
                return null;
            }
        };
    }
}

