/*
 * Decompiled with CFR 0.152.
 */
package org.arl.fjage.remote;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Logger;
import org.arl.fjage.AgentID;
import org.arl.fjage.auth.AllowAll;
import org.arl.fjage.auth.Firewall;
import org.arl.fjage.connectors.Connector;
import org.arl.fjage.connectors.TcpConnector;
import org.arl.fjage.remote.Action;
import org.arl.fjage.remote.JsonMessage;
import org.arl.fjage.remote.MasterContainer;
import org.arl.fjage.remote.RemoteContainer;
import org.arl.fjage.remote.SlaveContainer;

class ConnectionHandler
extends Thread {
    private final String ALIVE = "{\"alive\": true}";
    private final String SIGN_OFF = "{\"alive\": false}";
    private final int TIMEOUT = 5000;
    private final int FAILED_SIZE = 256;
    private Connector conn;
    private DataOutputStream out;
    private Map<String, Object> pending = Collections.synchronizedMap(new HashMap());
    private Deque<String> failed = new ArrayDeque<String>(256);
    private Logger log = Logger.getLogger(this.getClass().getName());
    private RemoteContainer container;
    private boolean alive;
    private boolean keepAlive;
    private boolean closeOnDead;
    private ExecutorService pool = Executors.newSingleThreadExecutor();
    private Set<AgentID> watchList = new HashSet<AgentID>();
    private Firewall fw;

    public ConnectionHandler(Connector conn, RemoteContainer container) {
        this.conn = conn;
        this.container = container;
        this.fw = new AllowAll();
        this.setName(conn.toString());
        this.alive = false;
        this.keepAlive = true;
        this.closeOnDead = conn instanceof TcpConnector && container instanceof MasterContainer;
    }

    public ConnectionHandler(Connector conn, RemoteContainer container, Firewall fw) {
        this.conn = conn;
        this.container = container;
        this.fw = fw;
        this.setName(conn.toString());
        this.alive = false;
        this.keepAlive = true;
        this.closeOnDead = conn instanceof TcpConnector && container instanceof MasterContainer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        BufferedReader in = new BufferedReader(new InputStreamReader(this.conn.getInputStream()));
        this.out = new DataOutputStream(this.conn.getOutputStream());
        if (this.keepAlive) {
            if (this.closeOnDead) {
                new Thread(this.getName() + ":init"){

                    @Override
                    public void run() {
                        ConnectionHandler.this.println("{\"alive\": true}");
                        try {
                            Thread.sleep(5000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        if (!ConnectionHandler.this.alive) {
                            ConnectionHandler.this.log.fine("Connection dead");
                            ConnectionHandler.this.close();
                        }
                    }
                }.start();
            } else {
                this.println("{\"alive\": true}");
            }
        }
        this.fw.authenticate(this.conn, null);
        while (this.conn != null) {
            String s = null;
            try {
                s = in.readLine();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (s == null) break;
            this.log.fine(this.getName() + " <<< " + s);
            if (this.keepAlive) {
                if (!this.alive) {
                    this.alive = true;
                    this.log.fine("Connection alive");
                } else if (s.equals("{\"alive\": false}")) {
                    this.alive = false;
                    this.log.fine("Peer signed off");
                    continue;
                }
                if (s.equals("{\"alive\": true}")) {
                    if (!(this.container instanceof SlaveContainer)) continue;
                    this.println("{\"alive\": true}");
                    continue;
                }
            }
            try {
                JsonMessage rq = JsonMessage.fromJson(s);
                if (rq.action == null) {
                    Object object;
                    if (rq.id == null) continue;
                    Object obj = this.pending.get(rq.id);
                    if (obj != null) {
                        this.pending.put(rq.id, rq);
                        object = obj;
                        synchronized (object) {
                            obj.notify();
                            continue;
                        }
                    }
                    if (rq.auth == null) continue;
                    object = this.failed;
                    synchronized (object) {
                        while (this.failed.size() >= 256) {
                            this.failed.poll();
                        }
                        this.failed.offer(rq.id);
                        continue;
                    }
                }
                if (rq.action == Action.AUTH) {
                    boolean b = this.fw.authenticate(this.conn, rq.creds);
                    this.respondAuth(rq, b);
                    continue;
                }
                if (this.fw.permit(rq)) {
                    this.pool.execute(new RemoteTask(rq));
                    continue;
                }
                this.respondAuth(rq, false);
            }
            catch (Exception ex) {
                this.log.warning("Bad JSON request: " + ex.toString() + " in " + s);
            }
        }
        this.fw.authenticate(this.conn, null);
        this.close();
        this.pool.shutdown();
    }

    @Override
    public String toString() {
        if (this.conn == null) {
            return super.toString();
        }
        return this.conn.toString();
    }

    private void respondAuth(JsonMessage rq, boolean auth) {
        JsonMessage rsp = new JsonMessage();
        rsp.inResponseTo = rq.action;
        rsp.id = rq.id;
        rsp.auth = auth;
        this.println(rsp.toJson());
    }

    private void respond(JsonMessage rq, boolean answer) {
        JsonMessage rsp = new JsonMessage();
        rsp.inResponseTo = rq.action;
        rsp.id = rq.id;
        rsp.answer = answer;
        this.println(rsp.toJson());
    }

    private void respond(JsonMessage rq, AgentID aid) {
        JsonMessage rsp = new JsonMessage();
        rsp.inResponseTo = rq.action;
        rsp.id = rq.id;
        rsp.agentID = aid;
        this.println(rsp.toJson());
    }

    private void respond(JsonMessage rq, AgentID[] aid) {
        JsonMessage rsp = new JsonMessage();
        rsp.inResponseTo = rq.action;
        rsp.id = rq.id;
        rsp.agentIDs = aid;
        this.println(rsp.toJson());
    }

    private void respond(JsonMessage rq, String[] svc) {
        JsonMessage rsp = new JsonMessage();
        rsp.inResponseTo = rq.action;
        rsp.id = rq.id;
        rsp.services = svc;
        this.println(rsp.toJson());
    }

    synchronized void println(String s) {
        block3: {
            if (this.out == null) {
                return;
            }
            try {
                this.out.write((s + "\n").getBytes(StandardCharsets.UTF_8));
                this.log.fine(this.getName() + " >>> " + s);
                this.conn.waitOutputCompletion(1000L);
            }
            catch (IOException ex) {
                if (s.equals("{\"alive\": false}")) break block3;
                this.log.warning("Write failed: " + ex.toString());
                this.close();
            }
        }
    }

    void printlnQueued(String s) {
        if (this.pool != null) {
            this.pool.execute(() -> this.println(s));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    JsonMessage printlnAndGetResponse(String s, String id, long timeout) {
        if (this.conn == null) {
            return null;
        }
        if (this.keepAlive && !this.alive && this.container instanceof MasterContainer) {
            return null;
        }
        this.pending.put(id, id);
        try {
            String string = id;
            synchronized (string) {
                this.println(s);
                id.wait(timeout);
            }
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
        Object rv = this.pending.get(id);
        this.pending.remove(id);
        if (rv instanceof JsonMessage) {
            return (JsonMessage)rv;
        }
        if (this.keepAlive && this.alive) {
            this.alive = false;
            this.log.fine("Connection dead");
            if (this.closeOnDead) {
                this.close();
            }
        }
        return null;
    }

    synchronized void close() {
        if (this.conn == null) {
            return;
        }
        if (this.keepAlive && this.container instanceof SlaveContainer) {
            this.println("{\"alive\": false}");
        }
        this.conn.close();
        this.conn = null;
        this.out = null;
        this.container.connectionClosed(this);
    }

    boolean isClosed() {
        return this.conn == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean wantsMessagesFor(AgentID aid) {
        if (!this.fw.permit(aid)) {
            return false;
        }
        Set<AgentID> set = this.watchList;
        synchronized (set) {
            if (this.watchList.isEmpty()) {
                return true;
            }
            return this.watchList.contains(aid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean checkAuthFailure(String id) {
        Deque<String> deque = this.failed;
        synchronized (deque) {
            return this.failed.contains(id);
        }
    }

    private class RemoteTask
    implements Runnable {
        private JsonMessage rq;

        RemoteTask(JsonMessage rq) {
            this.rq = rq;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            switch (this.rq.action) {
                case AGENTS: {
                    ConnectionHandler.this.respond(this.rq, ConnectionHandler.this.container.getLocalAgents());
                    break;
                }
                case CONTAINS_AGENT: {
                    ConnectionHandler.this.respond(this.rq, this.rq.agentID != null && ConnectionHandler.this.container.containsAgent(this.rq.agentID));
                    break;
                }
                case SERVICES: {
                    ConnectionHandler.this.respond(this.rq, ConnectionHandler.this.container.getLocalServices());
                    break;
                }
                case AGENT_FOR_SERVICE: {
                    ConnectionHandler.this.respond(this.rq, this.rq.service != null ? ConnectionHandler.this.container.localAgentForService(this.rq.service) : null);
                    break;
                }
                case AGENTS_FOR_SERVICE: {
                    ConnectionHandler.this.respond(this.rq, this.rq.service != null ? ConnectionHandler.this.container.localAgentsForService(this.rq.service) : null);
                    break;
                }
                case SEND: {
                    if (this.rq.relay != null) {
                        ConnectionHandler.this.container.send(this.rq.message, this.rq.relay);
                        break;
                    }
                    ConnectionHandler.this.container.send(this.rq.message);
                    break;
                }
                case SHUTDOWN: {
                    ConnectionHandler.this.container.shutdown();
                    break;
                }
                case WANTS_MESSAGES_FOR: {
                    Set set = ConnectionHandler.this.watchList;
                    synchronized (set) {
                        ConnectionHandler.this.watchList.clear();
                        for (AgentID aid : this.rq.agentIDs) {
                            ConnectionHandler.this.watchList.add(aid);
                        }
                        break;
                    }
                }
            }
        }
    }
}

