/*
 * Decompiled with CFR 0.152.
 */
package org.arl.fjage.remote;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.logging.Logger;
import org.arl.fjage.param.NamedParameter;
import org.arl.fjage.remote.JsonMessage;

public class EnumTypeAdapter
extends TypeAdapter<Object> {
    private static ClassLoader classloader = null;
    private static Logger log = Logger.getLogger(EnumTypeAdapter.class.getName());

    public static void enable(Class<?> cls) {
        JsonMessage.addTypeHierarchyAdapter(cls, (Object)new EnumTypeAdapter());
    }

    private static Class<? extends Enum> enumClass(String clsname) {
        try {
            if (classloader != null) {
                return Class.forName(clsname, true, classloader);
            }
            return Class.forName(clsname);
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                int pos = clsname.lastIndexOf(46);
                if (pos >= 0) {
                    String clsname1 = clsname.substring(0, pos);
                    if (classloader != null) {
                        Class.forName(clsname1, true, classloader);
                    } else {
                        Class.forName(clsname1);
                    }
                    clsname1 = clsname1 + '$' + clsname.substring(pos + 1);
                    if (classloader != null) {
                        return Class.forName(clsname1, true, classloader);
                    }
                    return Class.forName(clsname1);
                }
            }
            catch (ClassNotFoundException classNotFoundException2) {
                // empty catch block
            }
            log.fine("Class " + clsname + " could not be loaded");
            return null;
        }
    }

    public void write(JsonWriter out, Object value) throws IOException {
        if (value == null) {
            out.value((String)null);
        } else if (value instanceof NamedParameter) {
            out.value(value.toString());
        } else {
            out.value(value.getClass().getName().replace('$', '.') + "." + value.toString());
        }
    }

    public Object read(JsonReader in) throws IOException {
        if (in.peek() == JsonToken.NULL) {
            in.nextNull();
            return null;
        }
        String s = in.nextString();
        int pos = s.lastIndexOf(46);
        if (pos < 0) {
            return new NamedParameter(s);
        }
        String value = s.substring(pos + 1);
        Class<? extends Enum> cls = EnumTypeAdapter.enumClass(s.substring(0, pos));
        if (cls != null) {
            return Enum.valueOf(cls, value);
        }
        if (value != null) {
            return new NamedParameter(value);
        }
        return null;
    }

    static {
        try {
            Class<?> cls = Class.forName("groovy.lang.GroovyClassLoader");
            classloader = (ClassLoader)cls.newInstance();
            log.info("Groovy detected, using GroovyClassLoader");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

