/*
 * Decompiled with CFR 0.152.
 */
package org.arl.fjage.remote;

import java.io.Closeable;
import java.io.IOException;
import org.arl.fjage.Agent;
import org.arl.fjage.AgentID;
import org.arl.fjage.Container;
import org.arl.fjage.Message;
import org.arl.fjage.MessageFilter;
import org.arl.fjage.Messenger;
import org.arl.fjage.OneShotBehavior;
import org.arl.fjage.Platform;
import org.arl.fjage.RealTimePlatform;
import org.arl.fjage.remote.SlaveContainer;

public class Gateway
implements Messenger,
Closeable {
    public static final long NON_BLOCKING = 0L;
    public static final long BLOCKING = -1L;
    protected Container container = null;
    protected Agent agent = null;
    protected boolean shutdownContainer = true;

    protected Gateway() {
    }

    public Gateway(Platform platform, String hostname, int port) throws IOException {
        this.container = new SlaveContainer(platform, "Gateway@" + this.hashCode(), hostname, port);
        this.init();
        platform.start();
    }

    public Gateway(String hostname, int port) throws IOException {
        RealTimePlatform platform = new RealTimePlatform();
        this.container = new SlaveContainer((Platform)platform, "Gateway@" + this.hashCode(), hostname, port);
        this.init();
        platform.start();
    }

    public Gateway(Platform platform, String devname, int baud, String settings) throws IOException {
        this.container = new SlaveContainer(platform, "Gateway@" + this.hashCode(), devname, baud, settings);
        this.init();
        platform.start();
    }

    public Gateway(String devname, int baud, String settings) throws IOException {
        RealTimePlatform platform = new RealTimePlatform();
        this.container = new SlaveContainer(platform, "Gateway@" + this.hashCode(), devname, baud, settings);
        this.init();
        platform.start();
    }

    public Gateway(Container container) {
        this.container = container;
        this.shutdownContainer = false;
        this.init();
    }

    protected void init() {
        this.agent = new Agent(){
            private Message rsp;
            private Object sync = new Object();

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Message receive(final MessageFilter filter, final long timeout) {
                if (Thread.currentThread().getId() == this.tid) {
                    return super.receive(filter, timeout);
                }
                Object object = this.sync;
                synchronized (object) {
                    this.rsp = null;
                    try {
                        this.add(new OneShotBehavior(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void action() {
                                rsp = this.receive(filter, timeout);
                                Object object = sync;
                                synchronized (object) {
                                    sync.notify();
                                }
                            }
                        });
                        this.sync.wait();
                    }
                    catch (InterruptedException ex) {
                        Thread.currentThread().interrupt();
                        this.thread.interrupt();
                    }
                    return this.rsp;
                }
            }
        };
        this.container.add(this.getAgentID().getName(), this.agent);
    }

    public Container getContainer() {
        return this.container;
    }

    public Platform getPlatform() {
        return this.container.getPlatform();
    }

    public boolean authenticate(String creds) {
        if (this.container != null && this.container instanceof SlaveContainer) {
            return ((SlaveContainer)this.container).authenticate(creds);
        }
        return false;
    }

    public AgentID getAgentID() {
        return new AgentID("GatewayAgent@" + this.hashCode());
    }

    public void flush() {
        while (this.receive() != null) {
        }
    }

    @Override
    public void close() {
        if (this.container != null) {
            if (this.shutdownContainer) {
                this.container.shutdown();
            } else {
                this.container.kill(this.getAgentID());
            }
        }
        this.agent = null;
        this.container = null;
    }

    @Override
    public boolean send(final Message m) {
        if (this.agent == null) {
            return false;
        }
        this.agent.add(new OneShotBehavior(){

            @Override
            public void action() {
                this.agent.send(m);
            }
        });
        return true;
    }

    @Override
    public synchronized Message receive(MessageFilter filter, long timeout) {
        if (this.agent == null) {
            return null;
        }
        return this.agent.receive(filter, timeout);
    }

    @Override
    public Message receive(MessageFilter filter) {
        return this.receive(filter, 0L);
    }

    @Override
    public Message receive(long timeout) {
        return this.receive((MessageFilter)null, timeout);
    }

    @Override
    public final Message receive() {
        return this.receive((MessageFilter)null, 0L);
    }

    @Override
    public Message receive(Class<?> cls, long timeout) {
        return this.receive((Message m) -> cls.isInstance(m), timeout);
    }

    @Override
    public Message receive(Class<?> cls) {
        return this.receive(cls, 0L);
    }

    @Override
    public Message receive(final Message m, long timeout) {
        Message rsp;
        if (this.container instanceof SlaveContainer) {
            ((SlaveContainer)this.container).checkAuthFailure(m.getMessageID());
        }
        if ((rsp = this.receive(new MessageFilter(){
            private String mid;
            {
                this.mid = m.getMessageID();
            }

            @Override
            public boolean matches(Message m2) {
                String s = m2.getInReplyTo();
                if (s == null) {
                    return false;
                }
                return s.equals(this.mid);
            }
        }, timeout)) != null) {
            return rsp;
        }
        if (this.container instanceof SlaveContainer) {
            ((SlaveContainer)this.container).checkAuthFailure(m.getMessageID());
        }
        return null;
    }

    @Override
    public Message receive(Message m) {
        return this.receive(m, 0L);
    }

    @Override
    public Message request(Message msg, long timeout) {
        this.send(msg);
        return this.receive(msg, timeout);
    }

    @Override
    public Message request(Message msg) {
        return this.request(msg, 1000L);
    }

    public AgentID topic(String topic) {
        if (this.agent == null) {
            return null;
        }
        AgentID t = this.agent.topic(topic);
        if (t == null) {
            return null;
        }
        return new AgentID(t, (Messenger)this);
    }

    public AgentID topic(Enum<?> topic) {
        if (this.agent == null) {
            return null;
        }
        AgentID t = this.agent.topic(topic);
        if (t == null) {
            return null;
        }
        return new AgentID(t, (Messenger)this);
    }

    public AgentID topic(AgentID topic) {
        if (this.agent == null) {
            return null;
        }
        AgentID t = this.agent.topic(topic);
        if (t == null) {
            return null;
        }
        return new AgentID(t, (Messenger)this);
    }

    public AgentID topic(AgentID aid, String topic) {
        if (this.agent == null) {
            return null;
        }
        AgentID t = this.agent.topic(aid, topic);
        if (t == null) {
            return null;
        }
        return new AgentID(t, (Messenger)this);
    }

    public AgentID topic(AgentID aid, Enum<?> topic) {
        if (this.agent == null) {
            return null;
        }
        AgentID t = this.agent.topic(aid, topic);
        if (t == null) {
            return null;
        }
        return new AgentID(t, (Messenger)this);
    }

    public AgentID agent(String name) {
        return new AgentID(name, (Messenger)this);
    }

    public boolean subscribe(AgentID topic) {
        if (this.agent == null) {
            return false;
        }
        return this.agent.subscribe(topic);
    }

    public boolean unsubscribe(AgentID topic) {
        if (this.agent == null) {
            return false;
        }
        return this.agent.unsubscribe(topic);
    }

    public AgentID agentForService(String service) {
        if (this.container == null) {
            return null;
        }
        AgentID t = this.container.agentForService(service);
        if (t == null) {
            return null;
        }
        return new AgentID(t, (Messenger)this);
    }

    public AgentID agentForService(Enum<?> service) {
        if (this.container == null) {
            return null;
        }
        AgentID t = this.container.agentForService(service.getClass().getName() + "." + service.toString());
        if (t == null) {
            return null;
        }
        return new AgentID(t, (Messenger)this);
    }

    public AgentID[] agentsForService(String service) {
        if (this.container == null) {
            return null;
        }
        AgentID[] t = this.container.agentsForService(service);
        if (t == null) {
            return null;
        }
        for (int i = 0; i < t.length; ++i) {
            t[i] = new AgentID(t[i], (Messenger)this);
        }
        return t;
    }

    public AgentID[] agentsForService(Enum<?> service) {
        if (this.container == null) {
            return null;
        }
        AgentID[] t = this.container.agentsForService(service.getClass().getName() + "." + service.toString());
        if (t == null) {
            return null;
        }
        for (int i = 0; i < t.length; ++i) {
            t[i] = new AgentID(t[i], (Messenger)this);
        }
        return t;
    }

    public void finalize() {
        this.close();
    }
}

