/*
 * Decompiled with CFR 0.152.
 */
package org.arl.fjage.remote;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.arl.fjage.GenericValue;

class GenericValueAdapterFactory
implements TypeAdapterFactory {
    GenericValueAdapterFactory() {
    }

    public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
        Class rawType = type.getRawType();
        if (!rawType.equals(GenericValue.class)) {
            return null;
        }
        GenericValueAdapterFactory parent = this;
        return new TypeAdapter<T>(){

            public void write(JsonWriter out, T value) throws IOException {
                if (value == null) {
                    out.nullValue();
                    return;
                }
                Class<?> type = ((GenericValue)value).getType();
                if (type == null) {
                    out.nullValue();
                    return;
                }
                if (Number.class.isAssignableFrom(type)) {
                    out.value((Number)((GenericValue)value).getValue());
                } else if (type.equals(String.class)) {
                    out.value((String)((GenericValue)value).getValue());
                } else if (type.equals(Boolean.class)) {
                    out.value((Boolean)((GenericValue)value).getValue());
                } else if (List.class.isAssignableFrom(type) || type.isArray() && type.getComponentType().isPrimitive()) {
                    TypeAdapter delegate = gson.getAdapter(TypeToken.get(type));
                    Object v = ((GenericValue)value).getValue();
                    delegate.write(out, v);
                } else {
                    out.beginObject();
                    out.name("clazz").value(type.getName());
                    out.name("data");
                    TypeAdapter delegate = gson.getAdapter(TypeToken.get(type));
                    Object v = ((GenericValue)value).getValue();
                    delegate.write(out, v);
                    out.endObject();
                }
            }

            public T read(JsonReader in) throws IOException {
                JsonToken tok = in.peek();
                if (tok == JsonToken.NULL) {
                    in.nextNull();
                    return null;
                }
                if (tok == JsonToken.NUMBER) {
                    String s = in.nextString();
                    try {
                        if (s.contains(".")) {
                            return new GenericValue(Double.parseDouble(s));
                        }
                        return new GenericValue(Long.parseLong(s));
                    }
                    catch (NumberFormatException ex) {
                        return new GenericValue(null);
                    }
                }
                if (tok == JsonToken.STRING) {
                    return new GenericValue(in.nextString());
                }
                if (tok == JsonToken.BOOLEAN) {
                    return new GenericValue(in.nextBoolean());
                }
                if (tok == JsonToken.BEGIN_OBJECT) {
                    TypeToken tt = null;
                    GenericValue rv = null;
                    in.beginObject();
                    while (in.hasNext()) {
                        String name = in.nextName();
                        if (name.equals("clazz")) {
                            try {
                                Class<?> cls = Class.forName(in.nextString());
                                tt = TypeToken.get(cls);
                            }
                            catch (Exception cls) {}
                            continue;
                        }
                        if (name.equals("data") && tt != null) {
                            TypeAdapter delegate = gson.getAdapter(tt);
                            rv = new GenericValue(delegate.read(in));
                            continue;
                        }
                        in.skipValue();
                    }
                    in.endObject();
                    return rv;
                }
                if (tok == JsonToken.BEGIN_ARRAY) {
                    ArrayList<Object> list = new ArrayList<Object>();
                    in.beginArray();
                    while (in.hasNext()) {
                        JsonToken tok2 = in.peek();
                        String s = in.nextString();
                        if (tok2 != JsonToken.NUMBER) {
                            list.add(s);
                            continue;
                        }
                        try {
                            if (s.contains(".")) {
                                list.add(Double.parseDouble(s));
                                continue;
                            }
                            list.add(Long.parseLong(s));
                        }
                        catch (NumberFormatException ex) {
                            list.add(s);
                        }
                    }
                    in.endArray();
                    return new GenericValue(list);
                }
                return null;
            }
        };
    }
}

