/*
 * Decompiled with CFR 0.152.
 */
package org.arl.fjage.remote;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import org.arl.fjage.AgentID;
import org.arl.fjage.Message;
import org.arl.fjage.Platform;
import org.arl.fjage.auth.AllowAll;
import org.arl.fjage.auth.Firewall;
import org.arl.fjage.connectors.ConnectionListener;
import org.arl.fjage.connectors.Connector;
import org.arl.fjage.connectors.TcpServer;
import org.arl.fjage.remote.Action;
import org.arl.fjage.remote.ConnectionHandler;
import org.arl.fjage.remote.JsonMessage;
import org.arl.fjage.remote.RemoteContainer;

public class MasterContainer
extends RemoteContainer
implements ConnectionListener {
    private static final long TIMEOUT = 1000L;
    private TcpServer listener = null;
    private List<ConnectionHandler> slaves = new ArrayList<ConnectionHandler>();
    private boolean needsCleanup = false;
    private Firewall fw = new AllowAll();

    public MasterContainer(Platform platform) {
        super(platform);
        this.openTcpServer(0);
    }

    public MasterContainer(Platform platform, Firewall fw) {
        super(platform);
        this.fw = fw;
        this.openTcpServer(0);
    }

    public MasterContainer(Platform platform, int port) {
        super(platform);
        this.openTcpServer(port);
    }

    public MasterContainer(Platform platform, int port, Firewall fw) {
        super(platform);
        this.fw = fw;
        this.openTcpServer(port);
    }

    public MasterContainer(Platform platform, String name) {
        super(platform, name);
        this.openTcpServer(0);
    }

    public MasterContainer(Platform platform, String name, Firewall fw) {
        super(platform, name);
        this.fw = fw;
        this.openTcpServer(0);
    }

    public MasterContainer(Platform platform, String name, int port) {
        super(platform, name);
        this.openTcpServer(port);
    }

    public MasterContainer(Platform platform, String name, int port, Firewall fw) {
        super(platform, name);
        this.fw = fw;
        this.openTcpServer(port);
    }

    public int getPort() {
        if (this.listener == null) {
            return -1;
        }
        return this.listener.getPort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnector(Connector conn) {
        this.log.info("Listening on " + conn.getName());
        ConnectionHandler t = new ConnectionHandler(conn, this, this.fw);
        List<ConnectionHandler> list = this.slaves;
        synchronized (list) {
            this.slaves.add(t);
        }
        t.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnector(Connector conn, Firewall fw) {
        this.log.info("Listening on " + conn.getName());
        ConnectionHandler t = new ConnectionHandler(conn, this, fw);
        List<ConnectionHandler> list = this.slaves;
        synchronized (list) {
            this.slaves.add(t);
        }
        t.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getConnectors() {
        List<ConnectionHandler> list = this.slaves;
        synchronized (list) {
            String[] url = new String[1 + this.slaves.size()];
            url[0] = this.listener.toString();
            for (int i = 0; i < this.slaves.size(); ++i) {
                url[i + 1] = this.slaves.get(i).toString();
            }
            return url;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean isDuplicate(AgentID aid) {
        if (super.isDuplicate(aid)) {
            return true;
        }
        JsonMessage rq = new JsonMessage();
        rq.action = Action.CONTAINS_AGENT;
        rq.agentID = aid;
        rq.id = UUID.randomUUID().toString();
        String json = rq.toJson();
        if (this.needsCleanup) {
            this.cleanupSlaves();
        }
        List<ConnectionHandler> list = this.slaves;
        synchronized (list) {
            for (ConnectionHandler slave : this.slaves) {
                JsonMessage rsp = slave.printlnAndGetResponse(json, rq.id, 1000L);
                if (rsp == null || !rsp.answer.booleanValue()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean send(Message m) {
        return this.send(m, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean send(Message m, boolean relay) {
        if (!this.running) {
            return false;
        }
        AgentID aid = m.getRecipient();
        if (aid == null) {
            return false;
        }
        if (super.send(m, false) && !aid.isTopic()) {
            return true;
        }
        if (!relay) {
            return false;
        }
        JsonMessage rq = new JsonMessage();
        rq.action = Action.SEND;
        rq.message = m;
        rq.relay = false;
        String json = rq.toJson();
        if (this.needsCleanup) {
            this.cleanupSlaves();
        }
        List<ConnectionHandler> list = this.slaves;
        synchronized (list) {
            for (ConnectionHandler slave : this.slaves) {
                if (!slave.wantsMessagesFor(aid)) continue;
                slave.printlnQueued(json);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AgentID[] getAgents() {
        AgentID[] aids = super.getAgents();
        ArrayList<AgentID> rv = new ArrayList<AgentID>(Arrays.asList(aids));
        JsonMessage rq = new JsonMessage();
        rq.action = Action.AGENTS;
        rq.id = UUID.randomUUID().toString();
        String json = rq.toJson();
        if (this.needsCleanup) {
            this.cleanupSlaves();
        }
        List<ConnectionHandler> list = this.slaves;
        synchronized (list) {
            for (ConnectionHandler slave : this.slaves) {
                JsonMessage rsp = slave.printlnAndGetResponse(json, rq.id, 1000L);
                if (rsp == null || rsp.agentIDs == null) continue;
                rv.addAll(Arrays.asList(rsp.agentIDs));
            }
        }
        return rv.toArray(new AgentID[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getServices() {
        String[] svc = super.getServices();
        HashSet<String> rv = new HashSet<String>(Arrays.asList(svc));
        JsonMessage rq = new JsonMessage();
        rq.action = Action.SERVICES;
        rq.id = UUID.randomUUID().toString();
        String json = rq.toJson();
        if (this.needsCleanup) {
            this.cleanupSlaves();
        }
        List<ConnectionHandler> list = this.slaves;
        synchronized (list) {
            for (ConnectionHandler slave : this.slaves) {
                JsonMessage rsp = slave.printlnAndGetResponse(json, rq.id, 1000L);
                if (rsp == null || rsp.services == null) continue;
                rv.addAll(Arrays.asList(rsp.services));
            }
        }
        return rv.toArray(new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AgentID agentForService(String service) {
        AgentID aid = super.agentForService(service);
        if (aid != null) {
            return aid;
        }
        JsonMessage rq = new JsonMessage();
        rq.action = Action.AGENT_FOR_SERVICE;
        rq.service = service;
        rq.id = UUID.randomUUID().toString();
        String json = rq.toJson();
        if (this.needsCleanup) {
            this.cleanupSlaves();
        }
        List<ConnectionHandler> list = this.slaves;
        synchronized (list) {
            for (ConnectionHandler slave : this.slaves) {
                JsonMessage rsp = slave.printlnAndGetResponse(json, rq.id, 1000L);
                if (rsp == null || rsp.agentID == null || rsp.agentID.getName().length() <= 0) continue;
                return rsp.agentID;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AgentID[] agentsForService(String service) {
        ArrayList<AgentID> rv = new ArrayList<AgentID>();
        AgentID[] aids = super.agentsForService(service);
        if (aids != null) {
            rv.addAll(Arrays.asList(aids));
        }
        JsonMessage rq = new JsonMessage();
        rq.action = Action.AGENTS_FOR_SERVICE;
        rq.service = service;
        rq.id = UUID.randomUUID().toString();
        String json = rq.toJson();
        if (this.needsCleanup) {
            this.cleanupSlaves();
        }
        List<ConnectionHandler> list = this.slaves;
        synchronized (list) {
            for (ConnectionHandler slave : this.slaves) {
                JsonMessage rsp = slave.printlnAndGetResponse(json, rq.id, 1000L);
                if (rsp == null || rsp.agentIDs == null) continue;
                rv.addAll(Arrays.asList(rsp.agentIDs));
            }
        }
        return rv.toArray(new AgentID[0]);
    }

    @Override
    AgentID[] getLocalAgents() {
        return this.getAgents();
    }

    @Override
    String[] getLocalServices() {
        return this.getServices();
    }

    @Override
    AgentID localAgentForService(String service) {
        return this.agentForService(service);
    }

    @Override
    AgentID[] localAgentsForService(String service) {
        return this.agentsForService(service);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        if (!this.running) {
            return;
        }
        JsonMessage rq = new JsonMessage();
        rq.action = Action.SHUTDOWN;
        String json = rq.toJson();
        List<ConnectionHandler> list = this.slaves;
        synchronized (list) {
            for (ConnectionHandler slave : this.slaves) {
                slave.println(json);
                slave.close();
            }
            this.slaves.clear();
            this.needsCleanup = false;
        }
        if (this.listener != null) {
            this.listener.close();
            this.listener = null;
        }
        super.shutdown();
    }

    @Override
    public String toString() {
        String s = this.getClass().getName() + "@" + this.name;
        s = s + "/master/" + this.platform;
        return s;
    }

    @Override
    public void connectionClosed(ConnectionHandler handler) {
        this.log.info("Connection " + handler.getName() + " closed");
        this.needsCleanup = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connected(Connector conn) {
        this.log.info("Incoming connection " + conn.toString());
        ConnectionHandler t = new ConnectionHandler(conn, this, this.fw);
        List<ConnectionHandler> list = this.slaves;
        synchronized (list) {
            this.slaves.add(t);
        }
        t.start();
    }

    private void openTcpServer(int port) {
        this.listener = new TcpServer(port, this);
        this.log.info("Listening on port " + this.listener.getPort());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanupSlaves() {
        List<ConnectionHandler> list = this.slaves;
        synchronized (list) {
            this.slaves.removeIf(ConnectionHandler::isClosed);
        }
        this.needsCleanup = false;
    }
}

