/*
 * Decompiled with CFR 0.152.
 */
package org.arl.fjage.remote;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.logging.Logger;
import org.arl.fjage.AgentID;
import org.arl.fjage.GenericMessage;
import org.arl.fjage.GenericValue;
import org.arl.fjage.Message;
import org.arl.fjage.Performative;

class MessageAdapterFactory
implements TypeAdapterFactory {
    private static ClassLoader classloader = null;

    MessageAdapterFactory() {
    }

    public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
        Class rawType = type.getRawType();
        if (!Message.class.isAssignableFrom(rawType)) {
            return null;
        }
        final TypeAdapter delegate = gson.getDelegateAdapter((TypeAdapterFactory)this, type);
        final TypeAdapter perfDelegate = gson.getAdapter(TypeToken.get(Performative.class));
        final TypeAdapter aidDelegate = gson.getAdapter(TypeToken.get(AgentID.class));
        final TypeAdapter gvDelegate = gson.getAdapter(TypeToken.get(GenericValue.class));
        final MessageAdapterFactory parent = this;
        return new TypeAdapter<T>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void write(JsonWriter out, T value) throws IOException {
                try {
                    out.setSerializeNulls(true);
                    if (value == null) {
                        out.nullValue();
                    } else {
                        out.beginObject();
                        out.name("clazz").value(value.getClass().getName());
                        out.name("data");
                        if (value instanceof GenericMessage) {
                            GenericMessage msg = (GenericMessage)value;
                            out.beginObject();
                            out.name("msgID").value(msg.getMessageID());
                            out.name("inReplyTo").value(msg.getInReplyTo());
                            out.name("perf");
                            perfDelegate.write(out, (Object)msg.getPerformative());
                            out.name("recipient");
                            aidDelegate.write(out, (Object)msg.getRecipient());
                            out.name("sender");
                            aidDelegate.write(out, (Object)msg.getSender());
                            for (Object k : msg.keySet()) {
                                out.name(k.toString());
                                Object v = msg.get(k);
                                TypeAdapter delegate2 = gson.getAdapter(TypeToken.get(v.getClass()));
                                delegate2.write(out, v);
                            }
                            out.endObject();
                        } else {
                            delegate.write(out, value);
                        }
                        out.endObject();
                    }
                }
                finally {
                    out.setSerializeNulls(false);
                }
            }

            public T read(JsonReader in) throws IOException {
                if (in.peek() == JsonToken.NULL) {
                    in.nextNull();
                    return null;
                }
                Object rv = null;
                Class<?> cls = null;
                in.beginObject();
                while (in.hasNext()) {
                    String name = in.nextName();
                    if (name.equals("clazz")) {
                        String className = in.nextString();
                        try {
                            cls = classloader != null ? Class.forName(className, true, classloader) : Class.forName(className);
                        }
                        catch (Exception exception) {}
                        continue;
                    }
                    if (name.equals("data")) {
                        if (cls == null) {
                            rv = delegate.read(in);
                            continue;
                        }
                        if (cls.equals(GenericMessage.class)) {
                            GenericMessage msg = new GenericMessage();
                            in.beginObject();
                            block17: while (in.hasNext()) {
                                String fname = in.nextName();
                                if (in.peek() == JsonToken.NULL) {
                                    in.nextNull();
                                    continue;
                                }
                                switch (fname) {
                                    case "msgID": {
                                        msg.setMessageID(in.nextString());
                                        continue block17;
                                    }
                                    case "inReplyTo": {
                                        msg.setInReplyTo(in.nextString());
                                        continue block17;
                                    }
                                    case "perf": {
                                        msg.setPerformative((Performative)((Object)perfDelegate.read(in)));
                                        continue block17;
                                    }
                                    case "recipient": {
                                        msg.setRecipient((AgentID)aidDelegate.read(in));
                                        continue block17;
                                    }
                                    case "sender": {
                                        msg.setSender((AgentID)aidDelegate.read(in));
                                        continue block17;
                                    }
                                }
                                GenericValue v = (GenericValue)gvDelegate.read(in);
                                msg.put(fname, v.getValue());
                            }
                            in.endObject();
                            rv = msg;
                            continue;
                        }
                        TypeAdapter delegate1 = gson.getDelegateAdapter((TypeAdapterFactory)parent, TypeToken.get(cls));
                        rv = delegate1.read(in);
                        continue;
                    }
                    in.skipValue();
                }
                in.endObject();
                return rv;
            }
        };
    }

    static {
        try {
            Class<?> cls = Class.forName("groovy.lang.GroovyClassLoader");
            classloader = (ClassLoader)cls.newInstance();
            Logger log = Logger.getLogger(MessageAdapterFactory.class.getName());
            log.info("Groovy detected, using GroovyClassLoader");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

