/*
 * Decompiled with CFR 0.152.
 */
package org.arl.fjage.remote;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Set;
import java.util.UUID;
import org.arl.fjage.Agent;
import org.arl.fjage.AgentID;
import org.arl.fjage.Message;
import org.arl.fjage.Platform;
import org.arl.fjage.auth.AuthFailureException;
import org.arl.fjage.connectors.Connector;
import org.arl.fjage.connectors.SerialPortConnector;
import org.arl.fjage.connectors.TcpConnector;
import org.arl.fjage.remote.Action;
import org.arl.fjage.remote.ConnectionHandler;
import org.arl.fjage.remote.JsonMessage;
import org.arl.fjage.remote.RemoteContainer;

public class SlaveContainer
extends RemoteContainer {
    private static final long TIMEOUT = 2000L;
    private ConnectionHandler master;
    private String hostname;
    private String settings;
    private int port;
    private int baud;
    private boolean quit = false;
    private String watchListCache = null;

    public SlaveContainer(Platform platform, String hostname, int port) throws IOException {
        super(platform);
        this.hostname = hostname;
        this.port = port;
        this.baud = -1;
        this.connectToMaster();
    }

    public SlaveContainer(Platform platform, String name, String hostname, int port) throws IOException {
        super(platform, name);
        this.hostname = hostname;
        this.port = port;
        this.baud = -1;
        this.connectToMaster();
    }

    public SlaveContainer(Platform platform, String devname, int baud, String settings) throws IOException {
        super(platform);
        this.hostname = devname;
        this.port = -1;
        this.baud = baud;
        this.settings = settings;
        this.connectToMaster();
    }

    public SlaveContainer(Platform platform, String name, String devname, int baud, String settings) throws IOException {
        super(platform, name);
        this.hostname = devname;
        this.port = -1;
        this.baud = baud;
        this.settings = settings;
        this.connectToMaster();
    }

    public boolean authenticate(String creds) {
        if (this.master == null) {
            return false;
        }
        JsonMessage rq = new JsonMessage();
        rq.action = Action.AUTH;
        rq.creds = creds;
        rq.id = UUID.randomUUID().toString();
        String json = rq.toJson();
        JsonMessage rsp = this.master.printlnAndGetResponse(json, rq.id, 2000L);
        return rsp != null && rsp.auth != null && rsp.auth != false;
    }

    public void checkAuthFailure(String id) {
        if (this.master.checkAuthFailure(id)) {
            throw new AuthFailureException();
        }
    }

    @Override
    protected boolean isDuplicate(AgentID aid) {
        if (super.isDuplicate(aid)) {
            return true;
        }
        if (this.master == null) {
            return false;
        }
        JsonMessage rq = new JsonMessage();
        rq.action = Action.CONTAINS_AGENT;
        rq.agentID = aid;
        rq.id = UUID.randomUUID().toString();
        String json = rq.toJson();
        JsonMessage rsp = this.master.printlnAndGetResponse(json, rq.id, 2000L);
        return rsp != null && rsp.answer != null && rsp.answer != false;
    }

    @Override
    public boolean send(Message m) {
        return this.send(m, true);
    }

    @Override
    public boolean send(Message m, boolean relay) {
        if (!this.running) {
            return false;
        }
        if (this.master == null) {
            return false;
        }
        AgentID aid = m.getRecipient();
        if (aid == null) {
            return false;
        }
        if (aid.isTopic()) {
            if (!relay) {
                return super.send(m, false);
            }
            JsonMessage rq = new JsonMessage();
            rq.action = Action.SEND;
            rq.id = m.getMessageID();
            rq.message = m;
            rq.relay = true;
            String json = rq.toJson();
            this.master.println(json);
            return true;
        }
        if (super.send(m, false)) {
            return true;
        }
        if (!relay) {
            return false;
        }
        JsonMessage rq = new JsonMessage();
        rq.action = Action.SEND;
        rq.id = m.getMessageID();
        rq.message = m;
        rq.relay = true;
        String json = rq.toJson();
        this.master.println(json);
        return true;
    }

    @Override
    public AgentID[] getAgents() {
        if (this.master == null) {
            return null;
        }
        JsonMessage rq = new JsonMessage();
        rq.action = Action.AGENTS;
        rq.id = UUID.randomUUID().toString();
        String json = rq.toJson();
        JsonMessage rsp = this.master.printlnAndGetResponse(json, rq.id, 2000L);
        if (rsp == null) {
            return null;
        }
        if (rsp.auth != null && !rsp.auth.booleanValue()) {
            throw new AuthFailureException();
        }
        return rsp.agentIDs;
    }

    @Override
    public String[] getServices() {
        if (this.master == null) {
            return null;
        }
        JsonMessage rq = new JsonMessage();
        rq.action = Action.SERVICES;
        rq.id = UUID.randomUUID().toString();
        String json = rq.toJson();
        JsonMessage rsp = this.master.printlnAndGetResponse(json, rq.id, 2000L);
        if (rsp == null) {
            return null;
        }
        if (rsp.auth != null && !rsp.auth.booleanValue()) {
            throw new AuthFailureException();
        }
        return rsp.services;
    }

    @Override
    public AgentID agentForService(String service) {
        if (this.master == null) {
            return null;
        }
        JsonMessage rq = new JsonMessage();
        rq.action = Action.AGENT_FOR_SERVICE;
        rq.service = service;
        rq.id = UUID.randomUUID().toString();
        String json = rq.toJson();
        JsonMessage rsp = this.master.printlnAndGetResponse(json, rq.id, 2000L);
        if (rsp == null) {
            return null;
        }
        if (rsp.auth != null && !rsp.auth.booleanValue()) {
            throw new AuthFailureException();
        }
        return rsp.agentID;
    }

    @Override
    public AgentID[] agentsForService(String service) {
        if (this.master == null) {
            return null;
        }
        JsonMessage rq = new JsonMessage();
        rq.action = Action.AGENTS_FOR_SERVICE;
        rq.service = service;
        rq.id = UUID.randomUUID().toString();
        String json = rq.toJson();
        JsonMessage rsp = this.master.printlnAndGetResponse(json, rq.id, 2000L);
        if (rsp == null) {
            return null;
        }
        if (rsp.auth != null && !rsp.auth.booleanValue()) {
            throw new AuthFailureException();
        }
        return rsp.agentIDs;
    }

    @Override
    AgentID[] getLocalAgents() {
        return super.getAgents();
    }

    @Override
    String[] getLocalServices() {
        return super.getServices();
    }

    @Override
    AgentID localAgentForService(String service) {
        return super.agentForService(service);
    }

    @Override
    AgentID[] localAgentsForService(String service) {
        return super.agentsForService(service);
    }

    @Override
    public void shutdown() {
        this.quit = true;
        if (this.master != null) {
            this.master.close();
        }
        super.shutdown();
    }

    @Override
    public String getState() {
        if (!this.running) {
            return "Not running";
        }
        if (this.master == null) {
            return "Running, connecting to " + this.hostname + (this.port >= 0 ? ":" + this.port : "@" + this.baud) + "...";
        }
        return "Running, connected to " + this.hostname + (this.port >= 0 ? ":" + this.port : "@" + this.baud);
    }

    @Override
    public String toString() {
        String s = this.getClass().getName() + "@" + this.name;
        s = s + "/slave/" + this.platform;
        return s;
    }

    @Override
    public void connectionClosed(ConnectionHandler handler) {
    }

    @Override
    public AgentID add(String name, Agent agent) {
        AgentID aid = super.add(name, agent);
        if (aid != null) {
            this.updateWatchList();
        }
        return aid;
    }

    @Override
    public boolean kill(AgentID aid) {
        boolean rv = super.kill(aid);
        if (rv) {
            this.updateWatchList();
        }
        return rv;
    }

    @Override
    public boolean subscribe(AgentID aid, AgentID topic) {
        boolean rv = super.subscribe(aid, topic);
        if (rv) {
            this.updateWatchList();
        }
        return rv;
    }

    @Override
    public boolean unsubscribe(AgentID aid, AgentID topic) {
        boolean rv = super.unsubscribe(aid, topic);
        if (rv) {
            this.updateWatchList();
        }
        return rv;
    }

    @Override
    public void unsubscribe(AgentID aid) {
        super.unsubscribe(aid);
        this.updateWatchList();
    }

    private void tryConnecting() throws IOException {
        Connector conn = this.port >= 0 ? new TcpConnector(this.hostname, this.port) : new SerialPortConnector(this.hostname, this.baud, this.settings);
        this.master = new ConnectionHandler(conn, this);
    }

    private void connectToMaster() throws IOException {
        this.tryConnecting();
        new Thread(this.getClass().getSimpleName() + ">" + this.hostname){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    while (!SlaveContainer.this.quit) {
                        try {
                            SlaveContainer.this.tryConnecting();
                            SlaveContainer.this.log.info("Connected to " + SlaveContainer.this.hostname + ":" + (SlaveContainer.this.port >= 0 ? ":" + SlaveContainer.this.port : "@" + SlaveContainer.this.baud));
                            SlaveContainer.this.master.start();
                            SlaveContainer.this.master.join();
                            SlaveContainer.this.log.info("Connection to " + SlaveContainer.this.hostname + (SlaveContainer.this.port >= 0 ? ":" + SlaveContainer.this.port : "@" + SlaveContainer.this.baud) + " lost");
                            SlaveContainer slaveContainer = SlaveContainer.this;
                            synchronized (slaveContainer) {
                                SlaveContainer.this.master = null;
                            }
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        if (SlaveContainer.this.quit) continue;
                        Thread.sleep(1000L);
                    }
                }
                catch (InterruptedException ex) {
                    SlaveContainer.this.log.warning("Connection manager interrupted!");
                }
            }
        }.start();
    }

    private synchronized void updateWatchList() {
        if (this.master == null) {
            return;
        }
        ArrayList<AgentID> watchList = new ArrayList<AgentID>();
        for (AgentID aid : this.getLocalAgents()) {
            watchList.add(aid);
        }
        for (AgentID aid : this.topics.keySet()) {
            if (((Set)this.topics.get(aid)).size() <= 0) continue;
            watchList.add(aid);
        }
        JsonMessage rq = new JsonMessage();
        rq.action = Action.WANTS_MESSAGES_FOR;
        rq.agentIDs = new AgentID[watchList.size()];
        rq.agentIDs = watchList.toArray(rq.agentIDs);
        String json = rq.toJson();
        if (this.watchListCache == null || !this.watchListCache.equals(json)) {
            this.master.println(json);
            this.watchListCache = json;
        }
    }
}

