/*
 * Decompiled with CFR 0.152.
 */
package org.arl.fjage.shell;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Logger;
import org.arl.fjage.connectors.ConnectionListener;
import org.arl.fjage.connectors.Connector;
import org.arl.fjage.shell.ScriptEngine;
import org.arl.fjage.shell.Shell;
import org.jline.reader.CompletingParsedLine;
import org.jline.reader.EOFError;
import org.jline.reader.EndOfFileException;
import org.jline.reader.LineReader;
import org.jline.reader.LineReaderBuilder;
import org.jline.reader.Parser;
import org.jline.reader.UserInterruptException;
import org.jline.terminal.Terminal;
import org.jline.terminal.TerminalBuilder;
import org.jline.utils.AttributedString;
import org.jline.utils.AttributedStyle;

public class ConsoleShell
implements Shell,
ConnectionListener {
    private Terminal term = null;
    private LineReader console = null;
    private Connector connector = null;
    private ScriptEngine scriptEngine = null;
    private AttributedStyle promptStyle = null;
    private AttributedStyle inputStyle = null;
    private AttributedStyle outputStyle = null;
    private AttributedStyle notifyStyle = null;
    private AttributedStyle errorStyle = null;
    private Logger log = Logger.getLogger(this.getClass().getName());

    public ConsoleShell() {
        try {
            this.term = TerminalBuilder.terminal();
            this.setupStyles();
        }
        catch (IOException ex) {
            this.log.warning("Unable to open terminal: " + ex.toString());
        }
    }

    public ConsoleShell(InputStream in, OutputStream out) {
        try {
            this.term = TerminalBuilder.builder().system(false).type("xterm").streams(in, out).build();
            this.setupStyles();
        }
        catch (IOException ex) {
            this.log.warning("Unable to open terminal: " + ex.toString());
        }
    }

    public ConsoleShell(Connector connector) {
        try {
            InputStream in = connector.getInputStream();
            OutputStream out = connector.getOutputStream();
            connector.setConnectionListener(this);
            this.connector = connector;
            this.term = TerminalBuilder.builder().system(false).type("xterm").streams(in, out).build();
            this.setupStyles();
        }
        catch (IOException ex) {
            this.log.warning("Unable to open terminal: " + ex.toString());
        }
    }

    @Override
    public void connected(Connector connector) {
        try {
            if (this.console != null) {
                this.console.callWidget("redraw-line");
                this.console.callWidget("redisplay");
            }
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    private void setupStyles() {
        AttributedStyle style = new AttributedStyle();
        this.promptStyle = style.foreground(11);
        this.inputStyle = style.foreground(7);
        this.outputStyle = style.foreground(2);
        this.notifyStyle = style.foreground(12);
        this.errorStyle = style.foreground(1);
    }

    @Override
    public void init(ScriptEngine engine) {
        if (this.term == null) {
            return;
        }
        this.scriptEngine = engine;
        if ("dumb".equals(this.term.getType())) {
            this.console = LineReaderBuilder.builder().terminal(this.term).build();
            this.console.setVariable("disable-completion", (Object)true);
            return;
        }
        if (this.scriptEngine == null) {
            this.console = LineReaderBuilder.builder().terminal(this.term).option(LineReader.Option.AUTO_FRESH_LINE, true).build();
        } else {
            Parser parser = new Parser(){

                public CompletingParsedLine parse(String s, int cursor) {
                    if (!ConsoleShell.this.scriptEngine.isComplete(s)) {
                        throw new EOFError(-1, -1, "");
                    }
                    if (s.contains("\n") && cursor < s.length()) {
                        throw new EOFError(-1, -1, "");
                    }
                    return null;
                }

                public CompletingParsedLine parse(String s, int cursor, Parser.ParseContext context) {
                    return this.parse(s, cursor);
                }

                public boolean isEscapeChar(char ch) {
                    return false;
                }
            };
            this.console = LineReaderBuilder.builder().parser(parser).terminal(this.term).build();
            this.console.setVariable("disable-completion", (Object)true);
            this.console.setOpt(LineReader.Option.ERASE_LINE_ON_FINISH);
        }
    }

    @Override
    public void prompt(Object obj) {
        if (obj == null || this.console == null) {
            return;
        }
        this.console.printAbove(new AttributedString((CharSequence)obj.toString(), this.promptStyle));
    }

    @Override
    public void input(Object obj) {
        if (obj == null || this.console == null || this.isDumb()) {
            return;
        }
        this.console.printAbove(new AttributedString((CharSequence)obj.toString(), this.inputStyle));
    }

    @Override
    public void println(Object obj) {
        if (obj == null || this.console == null) {
            return;
        }
        this.console.printAbove(new AttributedString((CharSequence)obj.toString(), this.outputStyle));
    }

    @Override
    public void notify(Object obj) {
        if (obj == null || this.console == null) {
            return;
        }
        this.console.printAbove(new AttributedString((CharSequence)obj.toString(), this.notifyStyle));
    }

    @Override
    public void error(Object obj) {
        if (obj == null || this.console == null) {
            return;
        }
        this.console.printAbove(new AttributedString((CharSequence)obj.toString(), this.errorStyle));
    }

    @Override
    public String readLine(String prompt1, String prompt2, String line) {
        if (this.console == null) {
            return null;
        }
        try {
            this.console.setVariable("secondary-prompt-pattern", (Object)prompt2);
            return this.console.readLine(prompt1, null, (Character)null, line);
        }
        catch (UserInterruptException ex) {
            return "\u0003";
        }
        catch (EndOfFileException ex) {
            return null;
        }
        catch (Throwable ex) {
            this.log.warning(ex.toString());
            return "";
        }
    }

    @Override
    public boolean isDumb() {
        return "dumb".equals(this.term.getType());
    }

    @Override
    public void shutdown() {
        if (this.term != null) {
            try {
                this.term.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.term = null;
        }
        if (this.connector != null) {
            this.connector.close();
            this.connector = null;
        }
        this.console = null;
    }

    public String toString() {
        if (this.connector == null) {
            return "console://-";
        }
        return this.connector.toString();
    }
}

