/*
 * Decompiled with CFR 0.152.
 */
package org.arl.fjage.shell;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Documentation {
    protected List<String> doc = new ArrayList<String>();
    protected Map<String, Integer> ndx = new HashMap<String, Integer>();
    protected Pattern heading = Pattern.compile("^#+ +([^ ]+) +-.*$");
    protected Pattern section = Pattern.compile("^#+ .*$");

    public void add(String s) {
        String[] lines;
        for (String line : lines = s.split("\\r?\\n")) {
            Matcher m = this.heading.matcher(line);
            if (m.matches()) {
                this.ndx.put(m.group(1), this.doc.size());
            }
            this.doc.add(line);
        }
    }

    public String get() {
        StringBuilder sb = new StringBuilder();
        for (Integer v : this.ndx.values()) {
            String s = this.doc.get(v);
            if (!s.startsWith("# ")) continue;
            sb.append(s.substring(2));
            sb.append('\n');
        }
        return sb.toString();
    }

    public String search(String keyword) {
        keyword = keyword.toLowerCase();
        HashSet<String> topics = new HashSet<String>();
        String topic = null;
        for (String s : this.doc) {
            Matcher m = this.section.matcher(s);
            if (m.matches()) {
                topic = s.replaceAll("^#+ +", "- ");
            }
            if (!s.toLowerCase().contains(keyword)) continue;
            topics.add(topic);
        }
        if (topics.size() == 0) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("Possible topics:\n");
        for (String s : topics) {
            sb.append(s);
            sb.append('\n');
        }
        return sb.toString();
    }

    public String get(String keyword) {
        Integer pos = this.ndx.get(keyword);
        if (pos == null) {
            return this.search(keyword);
        }
        String s = this.doc.get(pos);
        int level = s.indexOf(32);
        if (level <= 0) {
            return null;
        }
        int endlevel = level;
        StringBuilder sb = new StringBuilder();
        sb.append(s.replaceAll("^#+ +", ""));
        sb.append('\n');
        int skip = 0;
        for (int i = pos + 1; i < this.doc.size(); ++i) {
            s = this.doc.get(i);
            Matcher m = this.section.matcher(s);
            if (m.matches()) {
                m = this.heading.matcher(s);
                level = s.indexOf(32);
                if (level <= endlevel) break;
                boolean nl = false;
                if (skip == 0 || level <= skip) {
                    if (skip > 0) {
                        nl = true;
                    }
                    skip = 0;
                    s = s.replaceAll("^#+ +", "");
                }
                if (m.matches()) {
                    skip = level;
                    sb.append("- ");
                    sb.append(s);
                    sb.append('\n');
                } else if (nl) {
                    sb.append('\n');
                }
            }
            if (skip != 0) continue;
            sb.append(s);
            sb.append('\n');
        }
        return sb.toString().replaceAll("\\n+$", "\n");
    }
}

