/*
 * Decompiled with CFR 0.152.
 */
package org.arl.fjage.shell;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.logging.Logger;
import org.arl.fjage.connectors.Connector;
import org.arl.fjage.shell.ScriptEngine;
import org.arl.fjage.shell.Shell;

public class DumbShell
implements Shell {
    private PrintStream out = null;
    private BufferedReader in = null;
    private Connector connector = null;
    private ScriptEngine scriptEngine = null;
    private Logger log = Logger.getLogger(this.getClass().getName());

    public DumbShell() {
        this.in = new BufferedReader(new InputStreamReader(System.in));
        this.out = System.out;
    }

    public DumbShell(InputStream in, OutputStream out) {
        this.in = new BufferedReader(new InputStreamReader(in));
        this.out = new PrintStream(out);
    }

    public DumbShell(Connector connector) {
        this.in = new BufferedReader(new InputStreamReader(connector.getInputStream()));
        this.out = new PrintStream(connector.getOutputStream());
        this.connector = connector;
    }

    @Override
    public void init(ScriptEngine engine) {
        this.scriptEngine = engine;
    }

    @Override
    public void prompt(Object obj) {
    }

    @Override
    public void input(Object obj) {
    }

    @Override
    public void println(Object obj) {
        if (this.out != null) {
            this.out.println(obj.toString());
        }
    }

    @Override
    public void notify(Object obj) {
        if (this.out != null) {
            this.out.println(obj.toString());
        }
    }

    @Override
    public void error(Object obj) {
        if (this.out != null) {
            this.out.println(obj.toString());
        }
    }

    @Override
    public String readLine(String prompt1, String prompt2, String line) {
        if (line != null && line.length() > 0) {
            return line;
        }
        if (this.in == null) {
            return null;
        }
        try {
            return this.in.readLine();
        }
        catch (IOException ex) {
            return null;
        }
    }

    @Override
    public boolean isDumb() {
        return true;
    }

    @Override
    public void shutdown() {
        if (this.connector != null) {
            this.connector.close();
            this.connector = null;
        }
        try {
            if (this.in != null) {
                this.in.close();
            }
            if (this.out != null) {
                this.out.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.in = null;
        this.out = null;
    }

    public String toString() {
        if (this.connector == null) {
            return "console://-";
        }
        return this.connector.toString();
    }
}

