/*
 * Decompiled with CFR 0.152.
 */
package org.arl.fjage.shell;

import java.io.File;
import java.io.Reader;
import java.util.List;
import org.arl.fjage.Message;
import org.arl.fjage.shell.ScriptEngine;
import org.arl.fjage.shell.Shell;

public class EchoScriptEngine
implements ScriptEngine {
    protected Shell shell = null;
    protected boolean busy = false;

    protected void println(String s) {
        if (this.shell != null) {
            this.shell.println(s);
        }
    }

    @Override
    public String getPrompt(boolean cont) {
        return "# ";
    }

    @Override
    public boolean isComplete(String cmd) {
        return true;
    }

    @Override
    public void bind(Shell shell) {
        this.shell = shell;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean exec(String cmd) {
        if (this.busy) {
            return false;
        }
        this.busy = true;
        this.println(cmd);
        try {
            EchoScriptEngine echoScriptEngine = this;
            synchronized (echoScriptEngine) {
                this.wait(500L);
            }
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
        this.busy = false;
        return true;
    }

    @Override
    public boolean exec(File script) {
        return false;
    }

    @Override
    public boolean exec(File script, List<String> args) {
        return false;
    }

    @Override
    public boolean exec(Class<?> script) {
        return false;
    }

    @Override
    public boolean exec(Class<?> script, List<String> args) {
        return false;
    }

    @Override
    public boolean exec(Reader reader, String name) {
        return false;
    }

    @Override
    public boolean exec(Reader reader, String name, List<String> args) {
        return false;
    }

    @Override
    public void deliver(Message msg) {
        if (this.shell != null) {
            this.shell.notify(msg.getSender().getName() + " >> " + msg.toString());
        }
    }

    @Override
    public boolean offer(String s) {
        return false;
    }

    @Override
    public String input() {
        return null;
    }

    @Override
    public boolean isBusy() {
        return this.busy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void abort() {
        EchoScriptEngine echoScriptEngine = this;
        synchronized (echoScriptEngine) {
            this.notify();
        }
    }

    @Override
    public void setVariable(String name, Object value) {
    }

    @Override
    public Object getVariable(String name) {
        return null;
    }

    @Override
    public void importClasses(String clazz) {
    }

    @Override
    public void shutdown() {
    }
}

